from calibre.web.feeds.news import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import BeautifulSoup

class HindustanTimesRecipe(BasicNewsRecipe):
    __license__  = 'GPL v3'
    __author__ = 'kwetal'
    language = 'en_IN'
    version = 1

    title = u'Hindustan Times'
    publisher = u'HT Media Limited'
    category = u'News, India'
    description = u'India\'s single largest circulated English daily offers holistic coverage of India and the world.'

    remove_empty_feeds = True
    no_stylesheets = True
    remove_javascript = True

    remove_attributes = ['style']

    feeds = []
    feeds.append((u'News: India', u'http://www.hindustantimes.com/news-feed/india-news/sid111.aspx'))
    feeds.append((u'News: World', u'http://www.hindustantimes.com/news-feed/world-news/sid113.aspx'))
    feeds.append((u'News: Indians Abroad', u'http://www.hindustantimes.com/news-feed/indians-abroad/sid114.aspx'))
    feeds.append((u'News: Sport', u'http://www.hindustantimes.com/news-feed/sports-news/sid115.aspx'))
    feeds.append((u'Views: Editorials', u'http://www.hindustantimes.com/editorial-views-on/exclusive-views/sid213.aspx'))
    feeds.append((u'Views: Columns', u'http://www.hindustantimes.com/editorial-views-on/celebrity-columnists/sid214.aspx'))
    feeds.append((u'Views: Interviews', u'http://www.hindustantimes.com/editorial-views-on/celebrity-interviews/sid215.aspx'))
    feeds.append((u'Business: Markets', u'http://www.hindustantimes.com/business-news/stock-market-news/lid312.aspx'))
    feeds.append((u'Business: Economy', u'http://www.hindustantimes.com/business-news/global-economy/sid313.aspx'))
    feeds.append((u'Business: Corporate News', u'http://www.hindustantimes.com/business-news/corporate-business-news/sid314.aspx'))
    feeds.append((u'Business: Interviews', u'http://www.hindustantimes.com/business-news/business-interview/sid315.aspx'))
    feeds.append((u'Business: Utility Bytes', u'http://www.hindustantimes.com/business-news/useful-short-news/sid316.aspx'))
    feeds.append((u'Business: Sectors', u'http://www.hindustantimes.com/business-news/business-sector-news/sid317.aspx'))
    feeds.append((u'Cricket: News', u'http://www.hindustantimes.com/cricket/cricket-news/sidc02.aspx'))
    feeds.append((u'Cricket: Domestic', u'http://www.hindustantimes.com/cricket/indian-domestic-cricket-news/sidc03.aspx'))
    feeds.append((u'Cricket: Interviews', u'http://www.hindustantimes.com/cricket/cricket-celebrity-interviews/sidc04.aspx'))
    feeds.append((u'Cricket: Columns', u'http://www.hindustantimes.com/cricket/celebrity-columnists/sidc05.aspx'))
    feeds.append((u'Cricket: Features', u'http://www.hindustantimes.com/cricket/cricket-feature-news/sidc06.aspx'))
    feeds.append((u'Cinema: Reviews', u'http://www.hindustantimes.com/cinema-news/movie-reviews/sid412.aspx'))
    feeds.append((u'Cinema: Previews', u'http://www.hindustantimes.com/cinema-news/previews/Preview-Accident-On-Hill-Road/Article1-492442.aspx'))
    feeds.append((u'Cinema: Gossip', u'http://www.hindustantimes.com/cinema-news/bollywood-gossip/sid414.aspx'))
    feeds.append((u'Cinema: Dress Circle', u'http://www.hindustantimes.com/movie-gossip-news/sid415.aspx'))
    feeds.append((u'Cinema: Hollywired', u'http://www.hindustantimes.com/cinema-news/hollywood-news/sid416.aspx'))
    feeds.append((u'Cinema: Regional Flavours', u'http://www.hindustantimes.com/cinema-news/regional-film-news/sid417.aspx'))
    feeds.append((u'Cinema: Scope', u'http://www.hindustantimes.com/feature-movies-news/lid419.aspx'))
    feeds.append((u'Cinema: Interviews', u'http://www.hindustantimes.com/cinema-news/celebrity-interviews/lid420.aspx'))
    feeds.append((u'Lifestyle: Fashion & Beauty', u'http://www.hindustantimes.com/lifestyle-news/fashion-beauty-news/sid512.aspx'))
    feeds.append((u'Lifestyle: Fitness', u'http://www.hindustantimes.com/lifestyle-news/fitness-tips/sid513.aspx'))
    feeds.append((u'Lifestyle: Travel', u'http://www.hindustantimes.com/lifestyle-news/travel-guide/sid514.aspx'))
    feeds.append((u'Lifestyle: Books', u'http://www.hindustantimes.com/lifestyle-news/books-news/sid515.aspx'))
    feeds.append((u'Lifestyle: Relationships', u'http://www.hindustantimes.com/lifestyle-news/relationship-advice/sid516.aspx'))
    feeds.append((u'Lifestyle: Small Screen', u'http://www.hindustantimes.com/lifestyle-news/small-screen-television-news/sid517.aspx'))
    feeds.append((u'Lifestyle: Food', u'http://www.hindustantimes.com/lifestyle-news/food-guide/sid518.aspx'))
    feeds.append((u'Lifestyle: Gadgets', u'http://www.hindustantimes.com/lifestyle-news/gadgets-news/sid519.aspx'))
    feeds.append((u'Lifestyle: Art & Culture', u'http://www.hindustantimes.com/lifestyle-news/art-and-culture-news/sid520.aspx'))
    feeds.append((u'Lifestyle: Good Living', u'http://www.hindustantimes.com/lifestyle-news/good-living/sid521.aspx'))
    feeds.append((u'', u''))

    extra_css = '''
                body{font-family:verdana,arial,helvetica,geneva,sans-serif;}
                img {float: right; margin-right: 0.5em}
                a, a[href] {text-decoration: none;}
                div.niauthor b a, div.nidate, div.storydatetime {font-size: x-small; font-weight: normal;
                    color: #666666; text-decoration: none;}
                div.copyright {font-size: small; color: #696969;}
                '''

    conversion_options = {'comments': description, 'tags': category, 'language': 'en',
                          'publisher': publisher}

    def parse_index(self):
        answer = []

        for feed in self.feeds:
            soup = self.index_to_soup(feed[1])
            articles = []

            if soup.find('div', attrs = {'id': 'contentarea1'}):
                for i in range(1, 3):
                    div = soup.find('div', attrs = {'id': 'contentarea' + str(i)})
                    if div:
                        for item in div.findAll('div', attrs = {'class': ['ni_diff', 'ni']}):
                            article = {'title': self.tag_to_string(item.h5.a), 'date': None,
                                       'url': item.h5.a['href'], 'description': self.tag_to_string(item.div)}
                            articles.append(article)

                answer.append((feed[0], articles))
            elif soup.find('div', attrs = {'class': 'contentarea1'}):
                div = soup.find('div', attrs = {'class': 'contentarea1'})
                items = div.findAll('div', attrs = {'class': 'contentitem'})
                if len(items) == 0:
                    items = div.findAll('div', attrs = {'class': 'ni'})

                for item in items:
                    description = self.tag_to_string(item.find('div', attrs = {'class': 'nikicker'}))
                    article = {'title': self.tag_to_string(item.h5.a), 'date': None,
                                       'url': item.h5.a['href'], 'description': description}
                    articles.append(article)

                answer.append((feed[0], articles))
            elif soup.find('div', attrs = {'class': 'colinterviewall bottomredline'}):
                items = soup.findAll(lambda tag: tag.name == 'div' and tag.has_key('class') and \
                                        tag['class'] == 'colinterview' and tag.parent.name == 'div' )
                if len(items) == 0:
                    items = soup.findAll('div', attrs = {'class': 'colinterview'})

                for item in items:
                    title = self.tag_to_string(item.find('h5'))
                    url = item.find('a', attrs = {'class': 'nihl'})['href']
                    description = self.tag_to_string(item.find('div', attrs = {'class': 'nikicker'}))

                    article = {'title': title, 'date': None, 'url': url, 'description': description}
                    articles.append(article)

                answer.append((feed[0], articles))

        return answer

    def print_version(self, url):
        return 'http://www.hindustantimes.com/StoryPage/Print/' + url.rpartition('-')[2]

    def preprocess_html(self, soup):
        story = soup.find('div', attrs = {'class': 'backgroundextension'})
        if story:
            email = story.find('div', attrs = {'class': 'niemail'})
            if email:
                email.extract()

        freshSoup = BeautifulSoup('<html><head><title></title></head><body></body></html>')
        freshSoup.body.append(story)

        return freshSoup