from calibre.web.feeds.news import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import BeautifulSoup

class ProPublicaRecipe(BasicNewsRecipe):
    __license__  = 'GPL v3'
    __author__ = 'kwetal'
    language = 'en_US'
    version = 1

    title = u'Pro Publica'
    publisher = u'ProPublica.org'
    category = u'Political blog'
    description = u'Independent investigative journalism in the public interest.'

    oldest_article = 14
    max_articles_per_feed = 100
    use_embedded_content = False

    remove_empty_feeds = True
    no_stylesheets = True
    remove_javascript = True

    keep_only_tags = []
    keep_only_tags.append(dict(name = 'div', attrs = {'class': 'article'}))

    remove_tags = []
    remove_tags.append(dict(name = 'div', attrs = {'id': 'rollups'}))
    remove_tags.append(dict(name = 'div', attrs = {'class': 'follow_info'}))
    remove_tags.append(dict(name = 'ul', attrs = {'class': 'long-tools-top'}))
    remove_tags.append(dict(name = 'ul', attrs = {'id': 'share-box'}))
    remove_tags.append(dict(name = 'div', attrs = {'class': 'tags'}))
    remove_tags.append(dict(name = 'ul', attrs = {'class': 'long-tools'}))
    remove_tags.append(dict(name = 'ul', attrs = {'id': 'share-box2'}))
    remove_tags.append(dict(name = 'p', attrs = {'id': 'original-url'}))

    feeds = []
    feeds.append((u'Top Stories', u'http://feeds.propublica.org/propublica/main'))
    feeds.append((u'Stimulus', u'http://feeds.propublica.org/propublica/watchdog/stimulus'))
    feeds.append((u'Bailout', u'http://feeds.propublica.org/propublica/watchdog/bailout'))
    feeds.append((u'Business', u'http://feeds.propublica.org/propublica/business-money'))
    feeds.append((u'Justice', u'http://feeds.propublica.org/propublica/justice-law'))
    feeds.append((u'Energy & Environment', u'http://feeds.propublica.org/propublica/energy-environment'))
    feeds.append((u'Government & Politics', u'http://feeds.propublica.org/propublica/government-politics'))
    feeds.append((u'Health & Science', u'http://feeds.propublica.org/propublica/health-science'))
    feeds.append((u'Media & Technology', u'http://feeds.propublica.org/propublica/media-technology'))
    feeds.append((u'National Security', u'http://feeds.propublica.org/propublica/national-security'))
    #feeds.append((u'', u''))

    conversion_options = {'comments': description, 'tags': category, 'language': 'en',
                          'publisher': publisher}

    extra_css = '''
                body{font-family:verdana,arial,helvetica,geneva,sans-serif;}
                img {float: left; margin-right: 0.5em;}
                h1 {text-align: left;}
                a, a[href] {text-decoration: none; color: blue;}
                div.cat {font-size: x-small; color: #666666; margin-bottom: 0.1em;}
                div.info {font-size: small; color: #696969;}
                '''
    