from calibre.web.feeds.news import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import BeautifulSoup

class JournalOfAccountancyRecipe(BasicNewsRecipe):
    __license__  = 'GPL v3'
    __author__ = 'kwetal'
    language = 'en_US'
    version = 1

    title = u'Journal of Accountancy'
    publisher = u'AICPA'
    category = u'News, Accountancy'
    description = u'Publication of the American Institute of Certified Public Accountants'

    use_embedded_content = False
    remove_empty_feeds = True
    oldest_article = 30
    max_articles_per_feed = 100

    no_stylesheets = True
    remove_javascript = True

    extra_css = '''
                body{font-family:verdana,arial,helvetica,geneva,sans-serif;}
                div#Rubricname {font-size: small; color: #666666; margin-bottom: 1em;}
                div#Headline {font-size: x-large; font-weight: bold; margin-bottom: 0.6em}
                div#SubHeadline {font-size: medium; font-weight: bold; margin-bottom: 1em}
                div#Authorname, div#Date {font-size: x-small; color: #696969;}
                '''

    conversion_options = {'comments': description, 'tags': category, 'language': 'en',
                          'publisher': publisher}

    keep_only_tags = []
    keep_only_tags.append(dict(name = 'div', attrs = {'id': 'Rubricname'}))
    keep_only_tags.append(dict(name = 'div', attrs = {'id': 'Headline'}))
    keep_only_tags.append(dict(name = 'div', attrs = {'id': 'SubHeadline'}))
    keep_only_tags.append(dict(name = 'div', attrs = {'id': 'Authorname'}))
    keep_only_tags.append(dict(name = 'div', attrs = {'id': 'Date'}))
    keep_only_tags.append(dict(name = 'div', attrs = {'id': 'BodyContent'}))

    remove_attributes = ['style']

    feeds = []
    feeds.append((u'Journal of Accountancy', u'http://feeds2.feedburner.com/JournalOfAccountancy'))