from calibre.web.feeds.news import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import BeautifulSoup

class ChowkRecipe(BasicNewsRecipe):
    __license__  = 'GPL v3'
    __author__ = 'kwetal'
    language = 'en'
    version = 1

    title = u'Chowk'
    publisher = u'chowk.com'
    category = u'Opinion, South Asia'
    description = u'Ideas & Identities of South Asia'

    use_embedded_content = False
    remove_empty_feeds = True
    oldest_article = 30
    max_articles_per_feed = 100

    #no_stylesheets = True
    remove_javascript = True
    encoding = 'utf-8'

    feeds = []
    feeds.append(('Chowk Articles', 'http://www.chowk.com/rss'))

    keep_only_tags = []
    keep_only_tags.append(dict(name = 'div', attrs = {'id': 'content'}))

    conversion_options = {'comments': description, 'tags': category, 'language': 'en',
                          'publisher': publisher}

    extra_css = '''
                body{font-family:verdana,arial,helvetica,geneva,sans-serif;}
                a {text-decoration: none; color: blue;}
                div.pgtitle {font-size: x-large; font-weight: bold;}
                div.wname, div.date {font-size: x-small; color: #696969;}
                div.wname {margin-top: 1em;}
                div.date {margin-bottom: 1em;}
                div.title {font-weight: bold;}
                '''


    def print_version(self, url):
        main, sep, id = url.rpartition('/')

        return main + '/print/' + id