from calibre.web.feeds.news import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import BeautifulSoup

class PravdaSlovakiaRecipe(BasicNewsRecipe):
    __license__  = 'GPL v3'
    __author__ = 'kwetal'
    language = 'sk_SK'
    version = 1

    title = u'Pravda'
    publisher = u''
    category = u'News, Newspaper'
    description = u'News from Slovakia'

    oldest_article = 1
    max_articles_per_feed = 100
    use_embedded_content = False
    remove_empty_feeds = True

    no_stylesheets = True
    remove_javascript = True

    # Feeds from: http://spravy.pravda.sk/info.asp?y=sk_kskop/rssinfo.htm
    feeds = []
    feeds.append((u'Spravodajstvo', u'http://servis.pravda.sk/rss.asp'))
    feeds.append((u'N\u00E1zory', u'http://servis.pravda.sk/rss.asp?o=sk_nazory'))
    feeds.append((u'\u0160port', u'http://servis.pravda.sk/rss.asp?o=sk_sport'))
    feeds.append((u'Peniaze', u'http://servis.pravda.sk/rss.asp?o=sk_peniaze'))
    feeds.append((u'Koktail', u'http://servis.pravda.sk/rss.asp?o=sk_koktail'))
    feeds.append((u'Kult\u00FAra', u'http://servis.pravda.sk/rss.asp?o=sk_kultura'))
    feeds.append((u'B\u00FDvanie', u'http://servis.pravda.sk/rss.asp?o=sk_byvanie'))
    feeds.append((u'Veda a Technika', u'http://servis.pravda.sk/rss.asp?o=sk_veda'))
    feeds.append((u'Mozgov\u00F1a', u'http://servis.pravda.sk/rss.asp?o=sk_mozgovna'))
    feeds.append((u'Auto', u'http://servis.pravda.sk/rss.asp?o=sk_autoweb'))
    feeds.append((u'Cestovanie', u'http://servis.pravda.sk/rss.asp?o=sk_cestovanie'))
    feeds.append((u'Regi\u00F3ny', u'http://servis.pravda.sk/rss.asp?r=sk_regiony'))
    feeds.append((u'Profesia', u'http://servis.pravda.sk/rss.asp?o=sk_profesia'))
    feeds.append((u'Zdravie', u'http://servis.pravda.sk/rss.asp?o=sk_zdravie'))
    feeds.append((u'\u010C\u00EDtajme de\u0165om', u'http://servis.pravda.sk/rss.asp?o=sk_citajme'))

    remove_tags = []
    remove_tags.append(dict(name = 'p', attrs = {'class': 'spatNaClanok'}))
    remove_tags.append(dict(name = 'ul'))

    extra_css = '''
                @font-face {font-family: "serif1";src:url(res:///opt/sony/ebook/FONT/tt0011m_.ttf)}
                @font-face {font-family: "sans1";src:url(res:///opt/sony/ebook/FONT/LiberationSans.ttf)}
                body {font-family: sans1, serif1;}
                .art-info {font-size: x-small; color: #696969; margin-bottom: 0.3em;}
                .img-info {font-size: x-small; color: #696969;}
                '''

    def print_version(self, url):
        ignore, sep, main = url.rpartition('/')
        app, sep, id = main.rpartition('?')

        app = app.replace('.asp', '')

        return 'http://sport.pravda.sk/tlac.asp?r=' + app + '&' + id
