#ifndef __IPC_H
#define __IPC_H

/**
 * File Name  : ipc.h
 *
 * Description: Internationalization and localization
 */

/*
 * This file is part of settings.
 *
 * settings is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * settings is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */
 
 
//============================================================================
// Public Functions
//============================================================================

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_set_services
 *
 * @brief  Setup IPC connection and register API functions
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
gboolean ipc_set_services ( void );

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_unset_services
 *
 * @brief  Unregister API functions
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void ipc_unset_services ( void );

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_sys_startup_complete
 *
 * @brief  Report "settings started" to sysd
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void ipc_sys_startup_complete ( void );

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_sys_set_busy
 *
 * @brief  Set busy indicator on/off
 *
 * @param  on  [Input] Busy indication
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
gboolean ipc_sys_set_busy( gboolean on );

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_menu_show_menu
 *
 * @brief  Set menu context
 *
 * @param  name  [Input] Menu name.
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
gboolean ipc_menu_show_menu( const char *name );

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_remove_menu
 *
 * @brief  Remove menu from popup menu.
 *
 * @param  name  [Input] Menu name.
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
gboolean ipc_remove_menu( const char *name );
 
/**---------------------------------------------------------------------------
 *
 * Name :  menu_init
 *
 * @brief  Initialise popup menus for settings application.
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void menu_init(void);

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_menu_popup
 *
 * @brief  Request popup menu state
 *
 * @param  state   [Input] State ("show", "hide", "toggle", "block", "unblock")
 *
 * @return FALSE if failed to set menu
 *
 *--------------------------------------------------------------------------*/
gboolean ipc_menu_popup(const char* state);
 
/**---------------------------------------------------------------------------
 *
 * Name :  ipc_menu_enable
 *
 * @brief  Enable items in popup menu
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void ipc_menu_enable();
 
/**---------------------------------------------------------------------------
 *
 * Name :  ipc_menu_disable
 *
 * @brief  Disable items in popup menu
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void ipc_menu_disable();

/**---------------------------------------------------------------------------
 *
 * Name :  ipc_set_stylus
 *
 * @brief  Request popup menu state
 *
 * @param  state   [Input] State ("enable", "disable", "suspend", "resume", 
 *                                "high", "normal")
 *
 * @return FALSE if failed to set stylus state
 *
 *--------------------------------------------------------------------------*/
gboolean ipc_set_stylus(const char* state);

/**---------------------------------------------------------------------------
 *
 * Name :  get_device_capabilities
 *
 * @brief  Get device capabilities from sysd.
 *
 * @param  has_stylus    [Output] Store result of hasing stylus.
 *         has_wifi      [Output] Store result of hasing wifi.
 *         has_bluetooth [Output] Store result of hasing bluetooth.
 *
 * @return FALSE if failed to get device capabilities.
 *
 *--------------------------------------------------------------------------*/
gboolean get_device_capabilities(gboolean* has_stylus,
                                 gboolean* has_wifi,
                                 gboolean* has_bluetooth);

/**---------------------------------------------------------------------------
 *
 * Name :  mount_sd_card
 *
 * @brief  Mount sd card via sysd.
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void mount_sd_card(void);

/**---------------------------------------------------------------------------
 *
 * Name :  unmount_sd_card
 *
 * @brief  Unmount sd card via sysd.
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void unmount_sd_card(void);

/**---------------------------------------------------------------------------
 *
 * Name :  prepare_sd_card
 *
 * @brief  Prepare sd card for iOn use.
 *
 * @param  --
 *
 * @return TRUE = ok, FALSE = error
 *
 *--------------------------------------------------------------------------*/
int prepare_sd_card(void);



#endif // __IPC_H
