#ifndef __MENU_H__
#define __MENU_H__

/**
 * File Name  : menu.h
 *
 * Description: Control the popup menus of the content browser
 */

/*
 * This file is part of ctb.
 *
 * ctb is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ctb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */


//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

G_BEGIN_DECLS


//----------------------------------------------------------------------------
// Definitions
//---------------------------------------------------------------------------- 

// states of a menu item
#define MENU_STATE_NORMAL       "normal";
#define MENU_STATE_SELECTED     "selected";
#define MENU_STATE_DISABLED     "disabled";


//----------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------


//============================================================================
// Public Functions
//============================================================================

/**---------------------------------------------------------------------------
 *
 * Name :  menu_init
 *
 * @brief  Initialise popup menus for content browser
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void menu_init ( void );


/**---------------------------------------------------------------------------
 *
 * Name :  menu_set_text
 *
 * @brief  Initialise text items in popup menus for content browser
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void menu_set_text ( void );


/**---------------------------------------------------------------------------
 *
 * Name :  menu_show
 *
 * @brief  Set the context menu to show in the popup menu
 *
 * @param  --
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void menu_show ( void );


/**---------------------------------------------------------------------------
 *
 * Name :  menu_select_view_type
 *
 * @brief  Set the specified option in the "View" group to selected
 *
 * @param  [in] view_type - currently active view type
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void menu_select_view_type ( const ctb_viewtypes_t view_type );


/**---------------------------------------------------------------------------
 *
 * Name :  menu_select_sort_order
 *
 * @brief  Set the specified option in the "Sort" group to selected
 *
 * @param  [in] sort_order - currently active sorting order
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void menu_select_sort_order ( const ctb_sort_order_t sort_order );


/**---------------------------------------------------------------------------
 *
 * Name :  menu_set_fixed_sort_order
 *
 * @brief  Force the current option in the "Sort" group to stay selected,
 *         disable the other options in the "Sort" group so the user understands
 *
 * @param  [in] is_fixed - whether or not the sorting order must be fixed
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void menu_set_fixed_sort_order ( const gboolean is_fixed );


/**---------------------------------------------------------------------------
 *
 * Name :  menu_set_current_is_desktop
 *
 * @brief  Specifies whether to show "special" menu for desktop or not.
 *
 * @param  [in] is_desktop - whether or not to show the "desktop" menu
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void menu_set_current_is_desktop ( const gboolean is_desktop );


//----------------------------------------------------------------------------
// Callbacks from popupmenu
//----------------------------------------------------------------------------

/**---------------------------------------------------------------------------
 *
 * Name :  menu_on_goto_location
 *
 * @brief  Go to the specified location
 *
 * @param  [in] location - location to display
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void menu_on_goto_location ( const gchar *location );


/**---------------------------------------------------------------------------
 *
 * Name :  menu_on_item_activated
 *
 * @brief  Handle a menu button that has been pressed by the user
 *
 * @param  [in] item  - item name of the activated item
 * @param  [in] group - name of the parent group of the activated item
 * @param  [in] menu  - name of the current menu
 * @param  [in] state - state of the item when activated
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
void menu_on_item_activated ( const gchar *item,
                              const gchar *group,
                              const gchar *menu,
                              const gchar *state );


G_END_DECLS

#endif /* __MENU_H__ */
