#!/bin/sh

set -e          # exit on error

die()
{
    echo "--- $*"
    exit 1
}

if [ $# -le 1 ]
then
    die "Must specify database as first parameter."
fi
database="$1"
shift

if [ $# -le 1 ]
then
    die "Must specify sort_priority as second parameter."
fi
sort_prio="$1"
shift

for file in $*
do
    filename="$file"
    file_type="${file##*.}"
    file_size=`stat -c '%s' $filename`
    file_time=`stat -c '%Y' $filename`
    sqlite3 "$database" "insert into file_metadata (filename, file_type, file_size, file_last_modified, sort_priority, is_directory) values ('$file', '$file_type', $file_size, $file_time, $sort_prio, 0);"
    sort_prio=`expr $sort_prio - 1`

    file_id=`sqlite3 "$database" "select file_id from file_metadata where filename='$filename';"`
    sqlite3 "$database" "insert into thumbnails (file_id) values ($file_id);"

    for size in mini small medium large
    do
        bitmap_file=`basename "$filename" ".$file_type"`
        bitmap_file="icon-${bitmap_file}-${size}.png"
        if [ -f "$bitmap_file" ]
        then
            column="thumb_data_$size"
            hexdump=`hexdump -v -e '/1 "%02x"' "$bitmap_file"`
            # hexdump=`od --output-duplicates --format=x1 --width=4 "$bitmap_file" | awk '{ printf("%s%s%s%s", $2, $3, $4, $5) }'`
            sqlite3 "$database" "update thumbnails set $column = x'$hexdump' where file_id = $file_id;"
        fi
    done
done

