/*
 * File Name: fileinfo.c
 */

/*
 * This file is part of ctb.
 *
 * ctb is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ctb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */

//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#include "fileinfo.h"


//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Static Variables
//----------------------------------------------------------------------------


//============================================================================
// Local Function Definitions
//============================================================================


//============================================================================
// Functions Implementation
//============================================================================

// create fs_fileinfo_t
fs_fileinfo_t* fs_fileinfo_new (void)
{
    fs_fileinfo_t *inf = NULL;    // return value

    // allocate object
    inf = g_new0(fs_fileinfo_t, 1);

    // allcoate string elements
    if (inf)
    {
        inf->filename = g_string_new("");
    }

    // note: g_new0() has initiliased the boolean elements as FALSE
    //                            and the integer elements as zero.

    return inf;
}


// free fs_fileinfo_t
void fs_fileinfo_free_impl (fs_fileinfo_t *inf)
{
    if (inf)
    {
        // free string elements
        if (inf->filename)
        {
            g_string_free(inf->filename, TRUE);
        }

        // free object
        g_free(inf);
    }
}
