from calibre.web.feeds.news import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import BeautifulSoup

class StrategyBusinessRecipe(BasicNewsRecipe):
    __license__  = 'GPL v3'
    __author__ = 'kwetal'
    language = 'en_US'
    version = 1

    title = u'Strategy+Business'
    publisher = u' Booz & Company'
    category = u'Business'
    description = u'Business magazine for senior business executives and the people who influence them.'

    oldest_article = 13 * 7 # 3 months
    max_articles_per_feed = 100
    use_embedded_content = False
    remove_empty_feeds = True

    no_stylesheets = True
    remove_javascript = True

    extra_css = '''
                body{font-family:verdana,arial,helvetica,geneva,sans-serif ;}
                a {text-decoration: none; color: blue;}
                h1 {margin: 0em; padding: 0em;}
                h2 {font-size: medium; font-weight: bold;}
                #sb-date {font-size: xx-small; color: #696969}
                #category {font-style: italic; font-size: small; color: black; margin: 0em; padding: 0em;}
                #byline {font-size: small; color: #666666}
                div.profiles {font-size: small; font-style: italic; color: #696969}
                div.profiles h2 {font-size: medium; font-style: normal; font-weight: bold; color: black}
                '''

    feeds = []
    feeds.append((u'Finance', u'http://feeds.feedburner.com/StrategyBusiness-Finance?format=xml'))
    feeds.append((u'Global Perspective', u'http://feeds.feedburner.com/StrategyBusiness-GlobalPerspective?format=xml'))
    feeds.append((u'Innovation', u'http://feeds.feedburner.com/StrategyBusiness-Innovation?format=xml'))
    feeds.append((u'Marketing And Sales', u'http://feeds.feedburner.com/StrategyBusiness-MarketingAndSales?format=xml'))
    feeds.append((u'Operations And Manufacturing', u'http://feeds.feedburner.com/StrategyBusiness-OperationsAndManufacturing?format=xml'))
    feeds.append((u'Organizations And People', u'http://feeds.feedburner.com/StrategyBusiness-OrganizationsAndPeople?format=xml'))
    feeds.append((u'Strategy And Leadership', u'http://feeds.feedburner.com/StrategyBusiness-StrategyAndLeadership?format=xml'))
    feeds.append((u'Sustainability', u'http://feeds.feedburner.com/StrategyBusiness-Sustainability?format=xml'))
    feeds.append((u'Auto, Airlines And Transport', u'http://feeds.feedburner.com/StrategyBusiness-AutoAirlinesAndTransport?format=xml'))
    feeds.append((u'Consumer Products', u'http://feeds.feedburner.com/StrategyBusiness-ConsumerProducts?format=xml'))
    feeds.append((u'Energy', u'http://feeds.feedburner.com/StrategyBusiness-Energy?format=xml'))
    feeds.append((u'Health Care', u'http://feeds.feedburner.com/StrategyBusiness-HealthCare?format=xml'))
    feeds.append((u'Technology', u'http://feeds.feedburner.com/StrategyBusiness-Technology?format=xml'))
    feeds.append((u'Thought Leaders', u'http://feeds.feedburner.com/StrategyBusiness-ThoughtLeaders?format=xml'))
    feeds.append((u'Business Literature', u'http://feeds.feedburner.com/StrategyBusiness-BusinessLiterature?format=xml'))
    feeds.append((u'Recent Research', u'http://feeds.feedburner.com/StrategyBusiness-RecentResearch?format=xml'))


    keep_only_tags = []
    keep_only_tags.append(dict(name = 'div', attrs = {'id': 'sb-column2'}))

    remove_tags = []
    remove_tags.append(dict(name = 'img', attrs = {'class': 'content1'}))
    remove_tags.append(dict(name = 'img', attrs = {'src': '/media/image/end_of_story.gif'}))
    remove_tags.append(dict(name = 'div', attrs = {'class': 'sb-adarea468'}))
    remove_tags.append(dict(name = 'div', attrs = {'id': 'sb-paging'}))
    remove_tags.append(dict(name = 'div', attrs = {'id': 'textsize'}))

    def print_version(self, url):
        return url + '?pg=all'