﻿#!/bin/sh
## Installing jukebox [mpd, mpc] for CF/MMC/SD/USB/main memory
# e.g. scriptdir=/mnt/usb/mpd_install
# e.g. jukebox_path=/mnt/usb
scriptdir=`/usr/bin/dirname $0`
export jukebox_path=`echo "$scriptdir" | sed 's/\/mpd_install//'`
cd $scriptdir
# bug logging
#echo "$jukebox_path" > jukebox_path.txt
# Removing not needed dirs
rm -r /mnt/mpd # v.2.1 bug :-(
rm -r ${jukebox_path}/mpd
rm -r ${jukebox_path}/Music
# [1] binary mpc
if [ ! -e /usr/bin/mpc ]; then
	# mpc was NOT found
	cd /usr/bin
	tar -zxf ${scriptdir}/mpc.tar.gz
fi	
# [2] script folder "Music" -> Music.tar.gz
cd ${jukebox_path}
tar -zxf ${scriptdir}/Music.tar.gz
# [3] directory "mpd" -> mpd.tar.gz
tar -zxf ${scriptdir}/mpd.tar.gz
# insert correct paths in mpd's config file
jukebox_path_sed=`echo "$jukebox_path"|tr / ¤`
# bug logging
#echo "$jukebox_path_sed" > jukebox_path_sed.txt
sed -i "s/jukebox_path/$jukebox_path_sed/" ${jukebox_path}/mpd/mpd.conf
cat ${jukebox_path}/mpd/mpd.conf|tr ¤ / >${jukebox_path}/mpd/mpd.conf
mv ${scriptdir}/installed.xml ${scriptdir}/manifest.xml