#!/bin/sh
##MPD Update Playlist Script
scriptdir=`/usr/bin/dirname $0`
cd $scriptdir
cd ../../../
jukebox_path=`pwd`
LD_LIBRARY_PATH=`echo "$jukebox_path"`/mpd/lib
cd $scriptdir
# bug logging
#echo "$LD_LIBRARY_PATH" > ld_library_path_M.txt
#echo "$jukebox_path" > jukebox_path_M.txt
killall mpd
# start mpd, update database
${jukebox_path}/mpd/bin/mpd ${jukebox_path}/mpd/mpd.conf
mpc clear
mpc update
# remove old files
cd ${jukebox_path}/Music/playlist/ && rm -rf *
cd ${jukebox_path}/mpd/playlists/ && rm -rf *

# PLAYLIST CONTROL
# [1] All-in-One Playlist
mkdir ${jukebox_path}/Music/playlist/01_aio
cd ${jukebox_path}/Music/playlist/01_aio
mpc clear
mpc ls|mpc add
mpc save aio
#touch run.sh
echo "#!/bin/sh" > run.sh
echo "mpc clear" >> run.sh
echo "mpc load aio" >> run.sh
echo "mpc play" >> run.sh
chmod a+x run.sh
#touch manifest.xml
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Load all Songs as Playlist</Title><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../note.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml

# script function
# Arguments are:
# $argument [e.g. artist] 
# $argument_c [e.g. Artist]
# $CL_number [e.g. 03]
# $sort_option [u or nu]
search_in_database () {
mkdir ${jukebox_path}/Music/playlist/$CL_number.$argument
cd ${jukebox_path}/Music/playlist/$CL_number.$argument
#touch manifest.xml 
# a DIR manifest
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>$argument_c</Title><Description>Search for $argument_c in Database</Description><Date>2007-04-14T10:27:07</Date></dc-metadata><y-metadata><image>../../note.png</image></y-metadata></metadata><directory><content>.</content></directory></package>" > manifest.xml
# start of clear playlist entry
mkdir ${jukebox_path}/Music/playlist/$CL_number.$argument/01_clear
cd ${jukebox_path}/Music/playlist/$CL_number.$argument/01_clear
#touch run.sh
echo "#!/bin/sh" > run.sh 
echo "mpc clear" >> run.sh
chmod a+x run.sh
#touch manifest.xml
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Clear All Songs in Playlist</Title><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../.delete.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
# end of clear playlist  entry
cd ${jukebox_path}/Music/playlist/$CL_number.$argument
cat ${jukebox_path}/mpd/mpd.db.txt |grep $argument_c:|sed "s/$argument_c: //"|sort -$sort_option > .search.txt
int=100
file_search=.search.txt
while read i  
do	
	mpc clear
	# "" is needed, when meta data is more than 1 word long
	mpc search $argument "$i"|mpc add
	mpc save $argument.$int
	mkdir ${jukebox_path}/Music/playlist/$CL_number.$argument/$argument.$int
	cd ${jukebox_path}/Music/playlist/$CL_number.$argument/$argument.$int
	# removing & bug
	i_mod=`echo "$i"|sed 's/&/&amp;/'`
	#touch manifest.xml
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>$i_mod</Title><Description>Add $argument_c $i_mod to Playlist</Description><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../.add.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
	#touch run.sh
	#echo "#!/bin/sh\nmpc load $argument.$int\nmpc play" > run.sh
	echo "#!/bin/sh" > run.sh
	echo "mpc load $argument.$int" >> run.sh
	echo "mpc play" >> run.sh
	chmod a+x run.sh
	int=`expr $int + 1`
done < "$file_search"
}

# [3] Artist Search
argument=artist
argument_c=Artist
CL_number=03
sort_option=u
search_in_database

# [4] Album Search
argument=album
argument_c=Album
CL_number=04
sort_option=u
search_in_database

# [5] Genre Search
argument=genre
argument_c=Genre
CL_number=05
sort_option=u
search_in_database

# [6] Date Search
argument=date
argument_c=Date
CL_number=06
sort_option=nu
search_in_database

# [2] external m3u-files
mkdir ${jukebox_path}/Music/playlist/02_external_m3u
cd ${jukebox_path}/Music/playlist/02_external_m3u
#touch manifest.xml
# a DIR manifest
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Load external .m3u Files</Title><Description>You can load here the playlists from the mp3 dir &#10;</Description><Date>2007-04-14T10:27:07</Date></dc-metadata><y-metadata><image>../../note.png</image></y-metadata></metadata><directory><content>.</content></directory></package>" > manifest.xml
# start of update external playlists
mkdir ${jukebox_path}/Music/playlist/02_external_m3u/01_update
cd ${jukebox_path}/Music/playlist/02_external_m3u/01_update
#touch manifest.xml
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Update external .m3u Files</Title><Description>Use this one after you have edited, added or removed .m3u files.</Description><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../note.png</image><startpage>../../../update_e.m3u.sh</startpage></y-metadata></metadata></package>" > manifest.xml
# end of update external playlists
cd ${jukebox_path}/Music/playlist/02_external_m3u
ls ${jukebox_path}/mp3|grep .m3u|sed 's/.m3u//'  >.e_m3u.txt
int=100
file_m3u=.e_m3u.txt
while read i  
do	
	mkdir ${jukebox_path}/Music/playlist/02_external_m3u/$int.e.m3u
	cd ${jukebox_path}/Music/playlist/02_external_m3u/$int.e.m3u
	cp ${jukebox_path}/mp3/"$i".m3u ${jukebox_path}/mpd/playlists/$int.e.m3u
	#touch manifest.xml
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>$i</Title><Description>Load $i as Playlist</Description><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../note.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
	#touch run.sh
	echo "#!/bin/sh" > run.sh
	echo "mpc clear" >> run.sh
	echo "mpc load $int.e" >> run.sh
	echo "mpc play" >> run.sh
	chmod a+x run.sh
	int=`expr $int + 1`
done < "$file_m3u"

# Create a click me of current playlist
mkdir ${jukebox_path}/Music/playlist/07_current_pl
cd ${jukebox_path}/Music/playlist/07_current_pl
#touch manifest.xml # a DIR manifest
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Contentlister Playlist of current Playlist</Title><Description>Click on a song to jump to that position in playlist.&#10;</Description><Date>2007-04-14T10:27:07</Date></dc-metadata><y-metadata><image>../../note.png</image></y-metadata></metadata><directory><content>.</content></directory></package>" > manifest.xml
# start of update CLPL
mkdir ${jukebox_path}/Music/playlist/07_current_pl/01_update
cd ${jukebox_path}/Music/playlist/07_current_pl/01_update
#touch manifest.xml
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Update Contentlister Playlist</Title><Description>Use this to list all songs of current running playlist</Description><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../note.png</image><startpage>../../../update_CL_PL.sh</startpage></y-metadata></metadata></package>" > manifest.xml
# end of update CLPL

# Load All Song in One Playlist, start playback
mpc clear
mpc load aio
mpc play
mpc volume 65
mpc repeat on
# Status Message
cd $scriptdir
cd ..
target=`pwd`
${target}/02_Status/run.sh
# lines which were added to Main.sh to handle different "1st run entry in CL"
cd $scriptdir
mv 2ndrun.xml manifest.xml
rm firstrun.sh