/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.adobe.epubcheck.api.EpubCheck;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.Reporter;
import org.dyno.visual.swing.layouts.Bilateral;
import org.dyno.visual.swing.layouts.Constraints;
import org.dyno.visual.swing.layouts.GroupLayout;
import org.dyno.visual.swing.layouts.Leading;

public class EpubvalidatorGUIen
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JButton jButton0;
    private JTextArea jTextArea0;
    private JScrollPane jScrollPane0;
    private JFileChooser fc = new JFileChooser();
    private JLabel jLabel0;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private static final String PREFERRED_LOOK_AND_FEEL = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";

    public EpubvalidatorGUIen() {
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("ePub validator");
        this.setLayout(new GroupLayout());
        this.add((Component)this.getJButton0(), new Constraints(new Leading(12, 12, 12), new Leading(12, 12, 12)));
        this.add((Component)this.getJLabel0(), new Constraints(new Leading(12, 98, 12, 12), new Leading(44, 46, 254)));
        this.add((Component)this.getJLabel1(), new Constraints(new Leading(122, 12, 12), new Leading(46, 10, 10)));
        this.add((Component)this.getJLabel2(), new Constraints(new Leading(13, 46, 10, 10), new Leading(66, 46, 254)));
        this.add((Component)this.getJLabel3(), new Constraints(new Leading(69, 12, 12), new Leading(66, 46, 254)));
        this.add((Component)this.getJLabel4(), new Constraints(new Leading(122, 12, 12), new Leading(66, 46, 254)));
        this.add((Component)this.getJScrollPane0(), new Constraints(new Bilateral(13, 12, 22), new Bilateral(88, 12, 22)));
        this.add((Component)this.getJLabel5(), new Constraints(new Leading(195, 12, 12), new Leading(68, 40, 37)));
        this.setSize(652, 331);
    }

    private JLabel getJLabel5() {
        if (this.jLabel5 == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("...");
        }
        return this.jLabel5;
    }

    private JLabel getJLabel4() {
        if (this.jLabel4 == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("Warnings:");
        }
        return this.jLabel4;
    }

    private JLabel getJLabel3() {
        if (this.jLabel3 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("...");
        }
        return this.jLabel3;
    }

    private JLabel getJLabel2() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Errors:");
        }
        return this.jLabel2;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("...");
        }
        return this.jLabel1;
    }

    private JLabel getJLabel0() {
        if (this.jLabel0 == null) {
            this.jLabel0 = new JLabel();
            this.jLabel0.setText("File to validate:");
        }
        return this.jLabel0;
    }

    private JScrollPane getJScrollPane0() {
        if (this.jScrollPane0 == null) {
            this.jScrollPane0 = new JScrollPane();
            this.jScrollPane0.setViewportView(this.getJTextArea0());
        }
        return this.jScrollPane0;
    }

    private JTextArea getJTextArea0() {
        if (this.jTextArea0 == null) {
            this.jTextArea0 = new JTextArea();
            this.jTextArea0.setEditable(false);
            this.jTextArea0.setFont(new Font("Arial", 0, 12));
            this.jTextArea0.setLineWrap(true);
            this.jTextArea0.setWrapStyleWord(true);
        }
        return this.jTextArea0;
    }

    private JButton getJButton0() {
        if (this.jButton0 == null) {
            this.jButton0 = new JButton();
            this.jButton0.setText("Open");
            this.jButton0.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EpubvalidatorGUIen.this.jButton0ActionActionPerformed(event);
                }
            });
        }
        return this.jButton0;
    }

    private static void installLnF() {
        try {
            String lnfClassname = PREFERRED_LOOK_AND_FEEL;
            if (lnfClassname == null) {
                lnfClassname = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lnfClassname);
        }
        catch (Exception e) {
            System.err.println("Cannot install com.sun.java.swing.plaf.windows.WindowsLookAndFeel on this platform:" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        EpubvalidatorGUIen.installLnF();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EpubvalidatorGUIen frame = new EpubvalidatorGUIen();
                frame.setDefaultCloseOperation(3);
                frame.setTitle("ePub validator");
                frame.getContentPane().setPreferredSize(frame.getSize());
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    private void jButton0ActionActionPerformed(ActionEvent event) {
        int returnVal;
        FileNameExtensionFilter filtr = new FileNameExtensionFilter("ePub", "epub");
        this.fc.addChoosableFileFilter(filtr);
        if (event.getSource() == this.jButton0 && (returnVal = this.fc.showOpenDialog(this)) == 0) {
            File file = this.fc.getSelectedFile();
            this.jLabel1.setText(file.getName());
            Reporter rp = new Reporter(file.getName());
            EpubCheck ch = new EpubCheck(file, rp);
            ch.validate();
            this.jLabel3.setText(Integer.toString(ch.errorCount));
            this.jLabel5.setText(Integer.toString(ch.warningCount));
            if (ch.errorCount != 0 || ch.warningCount != 0) {
                Iterator<String> kom = rp.komunikaty.iterator();
                String err = "";
                int i = 0;
                while (i < rp.komunikaty.size()) {
                    err = String.valueOf(err) + kom.next() + "\n\n";
                    ++i;
                }
                this.jTextArea0.setText(err);
            } else {
                this.jTextArea0.setText("File: \"" + file.getName() + "\" is a valid ePub");
            }
        }
    }

    public void setFc(JFileChooser fc) {
        this.fc = fc;
    }

    public JFileChooser getFc() {
        return this.fc;
    }
}

