/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.sax;

import com.thaiopensource.util.UriOrFile;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerImpl
implements ErrorHandler {
    private final PrintWriter err;
    private final String bundleName = "com.thaiopensource.xml.sax.resources.Messages";
    private ResourceBundle bundle = null;

    public ErrorHandlerImpl() {
        this(System.err);
    }

    public ErrorHandlerImpl(OutputStream os) {
        this.err = new PrintWriter(os);
    }

    public ErrorHandlerImpl(Writer w) {
        this.err = new PrintWriter(w);
    }

    public void close() {
        this.err.close();
    }

    private String getString(String key) {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com.thaiopensource.xml.sax.resources.Messages");
        }
        return this.bundle.getString(key);
    }

    private String format(String key, Object[] args) {
        return MessageFormat.format(this.getString(key), args);
    }

    @Override
    public void warning(SAXParseException e) throws SAXParseException {
        this.print(this.format("warning", new Object[]{this.formatMessage(e), this.formatLocation(e)}));
    }

    @Override
    public void error(SAXParseException e) {
        this.print(this.format("error", new Object[]{this.formatMessage(e), this.formatLocation(e)}));
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXParseException {
        throw e;
    }

    public void printException(Throwable e) {
        String loc = e instanceof SAXParseException ? this.formatLocation((SAXParseException)e) : "";
        String message = e instanceof SAXException ? this.formatMessage((SAXException)e) : this.formatMessage(e);
        this.print(this.format("fatal", new Object[]{message, loc}));
    }

    public void print(String message) {
        if (message.length() != 0) {
            this.err.println(message);
            this.err.flush();
        }
    }

    private String formatLocation(SAXParseException e) {
        Integer columnNumber;
        String systemId = e.getSystemId();
        int n = e.getLineNumber();
        Integer lineNumber = n >= 0 ? new Integer(n) : null;
        n = e.getColumnNumber();
        Integer n2 = columnNumber = n >= 0 ? new Integer(n) : null;
        if (systemId != null) {
            systemId = UriOrFile.uriToUriOrFile(systemId);
            if (lineNumber != null) {
                if (columnNumber != null) {
                    return this.format("locator_system_id_line_number_column_number", new Object[]{systemId, lineNumber, columnNumber});
                }
                return this.format("locator_system_id_line_number", new Object[]{systemId, lineNumber});
            }
            return this.format("locator_system_id", new Object[]{systemId});
        }
        if (lineNumber != null) {
            if (columnNumber != null) {
                return this.format("locator_line_number_column_number", new Object[]{lineNumber, columnNumber});
            }
            return this.format("locator_line_number", new Object[]{lineNumber});
        }
        return "";
    }

    private String formatMessage(SAXException se) {
        Exception e = se.getException();
        String detail = se.getMessage();
        if (e != null) {
            String detail2 = e.getMessage();
            if (detail2 == detail || e.getClass().getName().equals(detail)) {
                return this.formatMessage(e);
            }
            if (detail2 == null) {
                return this.format("exception", new Object[]{e.getClass().getName(), detail});
            }
            return this.format("tunnel_exception", new Object[]{e.getClass().getName(), detail, detail2});
        }
        if (detail == null) {
            detail = this.getString("no_detail");
        }
        return detail;
    }

    private String formatMessage(Throwable e) {
        String detail = e.getMessage();
        if (detail == null) {
            detail = this.getString("no_detail");
        }
        if (e instanceof FileNotFoundException) {
            return this.format("file_not_found", new Object[]{detail});
        }
        return this.format("exception", new Object[]{e.getClass().getName(), detail});
    }
}

