/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.nrl.ActionSet;
import com.thaiopensource.validate.nrl.AttributeActionSet;
import com.thaiopensource.validate.nrl.FilteredAttributes;
import com.thaiopensource.validate.nrl.Hashset;
import com.thaiopensource.validate.nrl.IntSet;
import com.thaiopensource.validate.nrl.Mode;
import com.thaiopensource.validate.nrl.ModeUsage;
import com.thaiopensource.validate.nrl.NoResultAction;
import com.thaiopensource.validate.nrl.ResultAction;
import com.thaiopensource.validate.nrl.SectionState;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ValidatorImpl
extends DefaultHandler
implements Validator {
    private static final String BEARER_URI = "";
    private static final String BEARER_LOCAL_NAME = "#bearer";
    private static final String NO_NS = "\u0000";
    private final ErrorHandler eh;
    private final PropertyMap properties;
    private Locator locator;
    private Section currentSection;
    private PrefixMapping prefixMapping = null;
    private final Hashtable validatorHandlerCache = new Hashtable();
    private final Localizer localizer = new Localizer(ValidatorImpl.class);
    private final Hashset noResultActions = new Hashset();
    private final Hashtable attributeNamespaceIndexSets = new Hashtable();
    private final Vector activeHandlersAttributeIndexSets = new Vector();
    private final Hashset attributeSchemas = new Hashset();
    private boolean attributeNamespaceRejected;
    private Attributes filteredAttributes;
    private final Mode startMode;

    ValidatorImpl(Mode mode, PropertyMap properties) {
        this.properties = properties;
        this.eh = ValidateProperty.ERROR_HANDLER.get(properties);
        this.startMode = mode;
        this.initCurrentSection();
    }

    private void initCurrentSection() {
        this.currentSection = new Section(NO_NS, null);
        this.currentSection.addChildMode(new ModeUsage(this.startMode, this.startMode), null);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int i = 0;
        int len = this.currentSection.activeHandlers.size();
        while (i < len) {
            ((ContentHandler)this.currentSection.activeHandlers.elementAt(i)).characters(ch, start, length);
            ++i;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        int i = 0;
        int len = this.currentSection.activeHandlers.size();
        while (i < len) {
            ((ContentHandler)this.currentSection.activeHandlers.elementAt(i)).ignorableWhitespace(ch, start, length);
            ++i;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!uri.equals(this.currentSection.ns)) {
            this.startSection(uri);
        }
        ++this.currentSection.depth;
        if (this.currentSection.contextDependent) {
            this.currentSection.context.push(localName);
        }
        boolean transformAttributes = this.processAttributes(attributes);
        int i = 0;
        int len = this.currentSection.activeHandlers.size();
        while (i < len) {
            ContentHandler handler = (ContentHandler)this.currentSection.activeHandlers.elementAt(i);
            handler.startElement(uri, localName, qName, transformAttributes ? ValidatorImpl.filterAttributes((IntSet)this.activeHandlersAttributeIndexSets.elementAt(i), attributes) : attributes);
            ++i;
        }
    }

    private static Attributes filterAttributes(IntSet indexSet, Attributes attributes) {
        if (indexSet.size() == attributes.getLength()) {
            return attributes;
        }
        return new FilteredAttributes(indexSet, attributes);
    }

    private boolean processAttributes(Attributes attributes) throws SAXException {
        if (this.currentSection.attributeProcessing == 0 || attributes.getLength() == 0) {
            return false;
        }
        this.attributeNamespaceIndexSets.clear();
        int i = 0;
        int len = attributes.getLength();
        while (i < len) {
            String ns = attributes.getURI(i);
            IntSet indexSet = (IntSet)this.attributeNamespaceIndexSets.get(ns);
            if (indexSet == null) {
                indexSet = new IntSet();
                this.attributeNamespaceIndexSets.put(ns, indexSet);
            }
            indexSet.add(i);
            ++i;
        }
        if (this.currentSection.attributeProcessing == 1 && this.attributeNamespaceIndexSets.size() == 1 && this.attributeNamespaceIndexSets.get(BEARER_URI) != null) {
            return false;
        }
        Vector handlerModes = this.currentSection.activeHandlersAttributeModeUsage;
        this.activeHandlersAttributeIndexSets.setSize(handlerModes.size());
        int i2 = 0;
        int len2 = handlerModes.size();
        while (i2 < len2) {
            this.activeHandlersAttributeIndexSets.setElementAt(new IntSet(), i2);
            ++i2;
        }
        boolean transform = false;
        Vector validationModes = this.currentSection.attributeValidationModeUsages;
        Enumeration e = this.attributeNamespaceIndexSets.keys();
        while (e.hasMoreElements()) {
            ModeUsage modeUsage;
            String ns = (String)e.nextElement();
            IntSet indexSet = (IntSet)this.attributeNamespaceIndexSets.get(ns);
            this.attributeSchemas.clear();
            this.filteredAttributes = null;
            this.attributeNamespaceRejected = false;
            int i3 = 0;
            int len3 = handlerModes.size();
            while (i3 < len3) {
                modeUsage = (ModeUsage)handlerModes.elementAt(i3);
                AttributeActionSet actions = this.processAttributeSection(modeUsage, ns, indexSet, attributes);
                if (actions.getAttach()) {
                    ((IntSet)this.activeHandlersAttributeIndexSets.get(i3)).addAll(indexSet);
                } else {
                    transform = true;
                }
                ++i3;
            }
            i3 = 0;
            len3 = validationModes.size();
            while (i3 < len3) {
                modeUsage = (ModeUsage)validationModes.elementAt(i3);
                this.processAttributeSection(modeUsage, ns, indexSet, attributes);
                ++i3;
            }
        }
        return transform;
    }

    private AttributeActionSet processAttributeSection(ModeUsage modeUsage, String ns, IntSet indexSet, Attributes attributes) throws SAXException {
        Mode mode = modeUsage.getMode(this.currentSection.context);
        AttributeActionSet actions = mode.getAttributeActions(ns);
        if (actions.getReject() && !this.attributeNamespaceRejected) {
            this.attributeNamespaceRejected = true;
            if (this.eh != null) {
                this.eh.error(new SAXParseException(this.localizer.message("reject_attribute", ns), this.locator));
            }
        }
        Schema[] schemas = actions.getSchemas();
        int j = 0;
        while (j < schemas.length) {
            if (!this.attributeSchemas.contains(schemas[j])) {
                this.attributeSchemas.add(schemas[j]);
                if (this.filteredAttributes == null) {
                    this.filteredAttributes = ValidatorImpl.filterAttributes(indexSet, attributes);
                }
                this.validateAttributes(schemas[j], this.filteredAttributes);
            }
            ++j;
        }
        return actions;
    }

    private void validateAttributes(Schema schema, Attributes attributes) throws SAXException {
        Validator validator = this.createValidator(schema);
        ContentHandler ch = validator.getContentHandler();
        this.initHandler(ch);
        ch.startElement(BEARER_URI, BEARER_LOCAL_NAME, BEARER_LOCAL_NAME, attributes);
        ch.endElement(BEARER_URI, BEARER_LOCAL_NAME, BEARER_LOCAL_NAME);
        this.cleanupHandler(ch);
        this.releaseValidator(schema, validator);
    }

    private void startSection(String uri) throws SAXException {
        Section section = new Section(uri, this.currentSection);
        Vector childPrograms = this.currentSection.childPrograms;
        this.noResultActions.clear();
        int i = 0;
        int len = childPrograms.size();
        while (i < len) {
            Program program = (Program)childPrograms.elementAt(i);
            ActionSet actions = program.modeUsage.getMode(this.currentSection.context).getElementActions(uri);
            ResultAction resultAction = actions.getResultAction();
            if (resultAction != null) {
                resultAction.perform(program.handler, section);
            }
            NoResultAction[] nra = actions.getNoResultActions();
            int j = 0;
            while (j < nra.length) {
                NoResultAction tem = nra[j];
                if (!this.noResultActions.contains(tem)) {
                    nra[j].perform(section);
                    this.noResultActions.add(tem);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        len = section.validators.size();
        while (i < len) {
            this.initHandler(((Validator)section.validators.elementAt(i)).getContentHandler());
            ++i;
        }
        this.currentSection = section;
    }

    private void initHandler(ContentHandler ch) throws SAXException {
        if (this.locator != null) {
            ch.setDocumentLocator(this.locator);
        }
        ch.startDocument();
        PrefixMapping pm = this.prefixMapping;
        while (pm != null) {
            ch.startPrefixMapping(pm.prefix, pm.uri);
            pm = pm.parent;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        int i = 0;
        int len = this.currentSection.activeHandlers.size();
        while (i < len) {
            ((ContentHandler)this.currentSection.activeHandlers.elementAt(i)).endElement(uri, localName, qName);
            ++i;
        }
        --this.currentSection.depth;
        if (this.currentSection.contextDependent) {
            this.currentSection.context.pop();
        }
        if (this.currentSection.depth == 0) {
            this.endSection();
        }
    }

    private void endSection() throws SAXException {
        int i = 0;
        int len = this.currentSection.validators.size();
        while (i < len) {
            Validator validator = (Validator)this.currentSection.validators.elementAt(i);
            this.cleanupHandler(validator.getContentHandler());
            this.releaseValidator((Schema)this.currentSection.schemas.elementAt(i), validator);
            this.currentSection.validators.setElementAt(null, i);
            ++i;
        }
        this.currentSection = this.currentSection.parent;
    }

    private void cleanupHandler(ContentHandler vh) throws SAXException {
        PrefixMapping pm = this.prefixMapping;
        while (pm != null) {
            vh.endPrefixMapping(pm.prefix);
            pm = pm.parent;
        }
        vh.endDocument();
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.prefixMapping = new PrefixMapping(prefix, uri, this.prefixMapping);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        this.prefixMapping = this.prefixMapping.parent;
    }

    private Validator createValidator(Schema schema) {
        Stack stack = (Stack)this.validatorHandlerCache.get(schema);
        if (stack == null) {
            stack = new Stack();
            this.validatorHandlerCache.put(schema, stack);
        }
        if (stack.empty()) {
            return schema.createValidator(this.properties);
        }
        return (Validator)stack.pop();
    }

    private void releaseValidator(Schema schema, Validator vh) {
        if (vh == null) {
            return;
        }
        vh.reset();
        ((Stack)this.validatorHandlerCache.get(schema)).push(vh);
    }

    @Override
    public void reset() {
        while (this.currentSection != null) {
            int i = 0;
            int len = this.currentSection.validators.size();
            while (i < len) {
                this.releaseValidator((Schema)this.currentSection.schemas.elementAt(i), (Validator)this.currentSection.validators.elementAt(i));
                ++i;
            }
            this.currentSection = this.currentSection.parent;
        }
        this.initCurrentSection();
    }

    @Override
    public ContentHandler getContentHandler() {
        return this;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this;
    }

    private static class PrefixMapping {
        final String prefix;
        final String uri;
        final PrefixMapping parent;

        PrefixMapping(String prefix, String uri, PrefixMapping parent) {
            this.prefix = prefix;
            this.uri = uri;
            this.parent = parent;
        }
    }

    private static class Program {
        final ModeUsage modeUsage;
        final ContentHandler handler;

        Program(ModeUsage modeUsage, ContentHandler handler) {
            this.modeUsage = modeUsage;
            this.handler = handler;
        }
    }

    private class Section
    implements SectionState {
        final Section parent;
        final String ns;
        int depth = 0;
        final Vector validators = new Vector();
        final Vector schemas = new Vector();
        final Vector activeHandlers = new Vector();
        final Vector activeHandlersAttributeModeUsage = new Vector();
        final Vector attributeValidationModeUsages = new Vector();
        final Vector childPrograms = new Vector();
        final Stack context = new Stack();
        boolean contextDependent = false;
        int attributeProcessing = 0;

        Section(String ns, Section parent) {
            this.ns = ns;
            this.parent = parent;
        }

        @Override
        public void addChildMode(ModeUsage modeUsage, ContentHandler handler) {
            this.childPrograms.addElement(new Program(modeUsage, handler));
            if (modeUsage.isContextDependent()) {
                this.contextDependent = true;
            }
        }

        @Override
        public void addValidator(Schema schema, ModeUsage modeUsage) {
            this.schemas.addElement(schema);
            Validator validator = ValidatorImpl.this.createValidator(schema);
            this.validators.addElement(validator);
            this.activeHandlers.addElement(validator.getContentHandler());
            this.activeHandlersAttributeModeUsage.addElement(modeUsage);
            this.attributeProcessing = Math.max(this.attributeProcessing, modeUsage.getAttributeProcessing());
            this.childPrograms.addElement(new Program(modeUsage, validator.getContentHandler()));
            if (modeUsage.isContextDependent()) {
                this.contextDependent = true;
            }
        }

        @Override
        public void addActiveHandler(ContentHandler handler, ModeUsage attributeModeUsage) {
            this.activeHandlers.addElement(handler);
            this.activeHandlersAttributeModeUsage.addElement(attributeModeUsage);
            this.attributeProcessing = Math.max(this.attributeProcessing, attributeModeUsage.getAttributeProcessing());
            if (attributeModeUsage.isContextDependent()) {
                this.contextDependent = true;
            }
        }

        @Override
        public void addAttributeValidationModeUsage(ModeUsage modeUsage) {
            int ap = modeUsage.getAttributeProcessing();
            if (ap != 0) {
                this.attributeValidationModeUsages.addElement(modeUsage);
                this.attributeProcessing = Math.max(ap, this.attributeProcessing);
                if (modeUsage.isContextDependent()) {
                    this.contextDependent = true;
                }
            }
        }

        @Override
        public void reject() throws SAXException {
            if (ValidatorImpl.this.eh != null) {
                ValidatorImpl.this.eh.error(new SAXParseException(ValidatorImpl.this.localizer.message("reject_element", this.ns), ValidatorImpl.this.locator));
            }
        }
    }
}

