/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.xml.util.Naming;
import java.util.Vector;

class Path {
    private final boolean root;
    private final Vector names;
    private static final int START = 0;
    private static final int IN_NAME = 1;
    private static final int AFTER_NAME = 2;
    private static final int AFTER_SLASH = 3;

    Path(boolean root, Vector names) {
        this.root = root;
        this.names = names;
    }

    boolean isRoot() {
        return this.root;
    }

    Vector getNames() {
        return this.names;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.root) {
            buf.append('/');
        }
        int i = 0;
        int len = this.names.size();
        while (i < len) {
            if (i != 0) {
                buf.append('/');
            }
            buf.append((String)this.names.elementAt(i));
            ++i;
        }
        return buf.toString();
    }

    static Vector parse(String str) throws ParseException {
        int state = 0;
        int nameStartIndex = -1;
        Vector<Path> paths = new Vector<Path>();
        Vector<String> names = new Vector<String>();
        boolean root = false;
        int i = 0;
        int len = str.length();
        while (i < len) {
            char c = str.charAt(i);
            block0 : switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (state != 1) break;
                    names.addElement(Path.makeName(str, nameStartIndex, i));
                    state = 2;
                    break;
                }
                case '/': {
                    switch (state) {
                        case 1: {
                            names.addElement(Path.makeName(str, nameStartIndex, i));
                            break;
                        }
                        case 0: {
                            root = true;
                            break;
                        }
                        case 3: {
                            throw new ParseException("unexpected_slash");
                        }
                    }
                    state = 3;
                    break;
                }
                case '|': {
                    switch (state) {
                        case 0: {
                            throw new ParseException("empty_path");
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            throw new ParseException("expected_name");
                        }
                        case 1: {
                            names.addElement(Path.makeName(str, nameStartIndex, i));
                        }
                    }
                    paths.addElement(new Path(root, names));
                    root = false;
                    names = new Vector();
                    state = 0;
                    break;
                }
                default: {
                    switch (state) {
                        case 2: {
                            throw new ParseException("expected_slash");
                        }
                        case 0: 
                        case 3: {
                            nameStartIndex = i;
                            state = 1;
                            break block0;
                        }
                    }
                }
            }
            ++i;
        }
        switch (state) {
            case 0: {
                throw new ParseException("empty_path");
            }
            case 2: {
                break;
            }
            case 3: {
                throw new ParseException("expected_name");
            }
            case 1: {
                names.addElement(Path.makeName(str, nameStartIndex, str.length()));
            }
        }
        paths.addElement(new Path(root, names));
        return paths;
    }

    private static String makeName(String str, int start, int end) throws ParseException {
        String name = str.substring(start, end);
        if (!Naming.isNcname(name)) {
            throw new ParseException("invalid_name");
        }
        return name;
    }

    public static void main(String[] args) throws ParseException {
        Vector paths = Path.parse(args[0]);
        int i = 0;
        while (i < paths.size()) {
            Path path;
            if (i != 0) {
                System.out.println("---");
            }
            if ((path = (Path)paths.elementAt(i)).isRoot()) {
                System.out.println("/");
            }
            int j = 0;
            while (j < path.getNames().size()) {
                System.out.println(path.getNames().elementAt(j));
                ++j;
            }
            ++i;
        }
    }

    static class ParseException
    extends Exception {
        private final String messageKey;

        ParseException(String messageKey) {
            super(messageKey);
            this.messageKey = messageKey;
        }

        public String getMessageKey() {
            return this.messageKey;
        }
    }
}

