/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.validate.nrl.IntSet;
import org.xml.sax.Attributes;

class FilteredAttributes
implements Attributes {
    private final Attributes attributes;
    private final IntSet indexSet;
    private int[] reverseIndexMap;

    public FilteredAttributes(IntSet indexSet, Attributes attributes) {
        this.indexSet = indexSet;
        this.attributes = attributes;
    }

    private int reverseIndex(int k) {
        if (this.reverseIndexMap == null) {
            this.reverseIndexMap = new int[this.attributes.getLength()];
            int i = 0;
            int len = this.indexSet.size();
            while (i < len) {
                this.reverseIndexMap[this.indexSet.get((int)i)] = i + 1;
                ++i;
            }
        }
        return this.reverseIndexMap[k] - 1;
    }

    @Override
    public int getLength() {
        return this.indexSet.size();
    }

    @Override
    public String getURI(int index) {
        if (index < 0 || index >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getURI(this.indexSet.get(index));
    }

    @Override
    public String getLocalName(int index) {
        if (index < 0 || index >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getLocalName(this.indexSet.get(index));
    }

    @Override
    public String getQName(int index) {
        if (index < 0 || index >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getQName(this.indexSet.get(index));
    }

    @Override
    public String getType(int index) {
        if (index < 0 || index >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getType(this.indexSet.get(index));
    }

    @Override
    public String getValue(int index) {
        if (index < 0 || index >= this.indexSet.size()) {
            return null;
        }
        return this.attributes.getValue(this.indexSet.get(index));
    }

    @Override
    public int getIndex(String uri, String localName) {
        int n = this.attributes.getIndex(uri, localName);
        if (n < 0) {
            return n;
        }
        return this.reverseIndex(n);
    }

    @Override
    public int getIndex(String qName) {
        int n = this.attributes.getIndex(qName);
        if (n < 0) {
            return n;
        }
        return this.reverseIndex(n);
    }

    private int getRealIndex(String uri, String localName) {
        int index = this.attributes.getIndex(uri, localName);
        if (index < 0 || this.reverseIndex(index) < 0) {
            return -1;
        }
        return index;
    }

    private int getRealIndex(String qName) {
        int index = this.attributes.getIndex(qName);
        if (index < 0 || this.reverseIndex(index) < 0) {
            return -1;
        }
        return index;
    }

    @Override
    public String getType(String uri, String localName) {
        return this.attributes.getType(this.getRealIndex(uri, localName));
    }

    @Override
    public String getValue(String uri, String localName) {
        return this.attributes.getValue(this.getRealIndex(uri, localName));
    }

    @Override
    public String getType(String qName) {
        return this.attributes.getType(this.getRealIndex(qName));
    }

    @Override
    public String getValue(String qName) {
        return this.attributes.getValue(this.getRealIndex(qName));
    }
}

