/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class UriOrFile {
    private UriOrFile() {
    }

    public static String toUri(String uriOrFile) {
        if (!UriOrFile.hasScheme(uriOrFile)) {
            try {
                return UriOrFile.fileToUri(uriOrFile);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uriOrFile;
    }

    private static boolean hasScheme(String str) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        if (!UriOrFile.isAlpha(str.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < len) {
            char c = str.charAt(i);
            switch (c) {
                case ':': {
                    return i != 1;
                }
                case '+': 
                case '-': {
                    break;
                }
                default: {
                    if (UriOrFile.isAlnum(c)) break;
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean isAlpha(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isAlnum(char c) {
        return UriOrFile.isAlpha(c) || '0' <= c && c <= '9';
    }

    public static String fileToUri(String file) throws MalformedURLException {
        return UriOrFile.fileToUri(new File(file));
    }

    public static String fileToUri(File file) throws MalformedURLException {
        String path = file.getAbsolutePath().replace(File.separatorChar, '/');
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = String.valueOf('/') + path;
        }
        return new URL("file", "", path).toString();
    }

    public static String uriToUriOrFile(String uri) {
        if (!uri.startsWith("file:")) {
            return uri;
        }
        uri = uri.substring(5);
        int nSlashes = 0;
        while (nSlashes < uri.length() && uri.charAt(nSlashes) == '/') {
            ++nSlashes;
        }
        File f = new File(uri.substring(nSlashes).replace('/', File.separatorChar));
        if (f.isAbsolute()) {
            return f.toString();
        }
        return uri.replace('/', File.separatorChar);
    }

    public static void main(String[] args) {
        System.err.println(UriOrFile.uriToUriOrFile(args[0]));
    }
}

