/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AnyNameClass;
import com.thaiopensource.relaxng.impl.AnyNameExceptNameClass;
import com.thaiopensource.relaxng.impl.AttributeNameClassChecker;
import com.thaiopensource.relaxng.impl.BuiltinDatatypeLibraryFactory;
import com.thaiopensource.relaxng.impl.ChoiceNameClass;
import com.thaiopensource.relaxng.impl.ErrorNameClass;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameFormatter;
import com.thaiopensource.relaxng.impl.NsNameClass;
import com.thaiopensource.relaxng.impl.NsNameExceptNameClass;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFuture;
import com.thaiopensource.relaxng.impl.RefPattern;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import com.thaiopensource.relaxng.parse.Annotations;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.CommentList;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.relaxng.parse.DataPatternBuilder;
import com.thaiopensource.relaxng.parse.Div;
import com.thaiopensource.relaxng.parse.ElementAnnotationBuilder;
import com.thaiopensource.relaxng.parse.Grammar;
import com.thaiopensource.relaxng.parse.GrammarSection;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Include;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.Location;
import com.thaiopensource.relaxng.parse.ParseReceiver;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.parse.ParsedElementAnnotation;
import com.thaiopensource.relaxng.parse.ParsedNameClass;
import com.thaiopensource.relaxng.parse.ParsedPattern;
import com.thaiopensource.relaxng.parse.ParsedPatternFuture;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.SubParser;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SchemaBuilderImpl
implements SchemaBuilder,
ElementAnnotationBuilder,
CommentList {
    private final SchemaBuilderImpl parent;
    private boolean hadError = false;
    private final SubParser subParser;
    private final SchemaPatternBuilder pb;
    private final DatatypeLibraryFactory datatypeLibraryFactory;
    private final String inheritNs;
    private final ErrorHandler eh;
    private final OpenIncludes openIncludes;
    private final AttributeNameClassChecker attributeNameClassChecker = new AttributeNameClassChecker();
    static final Localizer localizer = new Localizer(SchemaBuilderImpl.class);

    public static Pattern parse(Parseable parseable, ErrorHandler eh, DatatypeLibraryFactory datatypeLibraryFactory, SchemaPatternBuilder pb, boolean isAttributesPattern) throws IncorrectSchemaException, IOException, SAXException {
        try {
            SchemaBuilderImpl sb = new SchemaBuilderImpl(parseable, eh, new BuiltinDatatypeLibraryFactory(datatypeLibraryFactory), pb);
            ParsedPattern pp = parseable.parse(sb, new RootScope(sb));
            if (isAttributesPattern) {
                pp = sb.wrapAttributesPattern(pp);
            }
            return sb.expandPattern((Pattern)pp);
        }
        catch (IllegalSchemaException e) {
            throw new IncorrectSchemaException();
        }
        catch (BuildException e) {
            throw SchemaBuilderImpl.unwrapBuildException(e);
        }
    }

    public static PatternFuture installHandlers(ParseReceiver parser, XMLReader xr, ErrorHandler eh, DatatypeLibraryFactory dlf, SchemaPatternBuilder pb) throws SAXException {
        final SchemaBuilderImpl sb = new SchemaBuilderImpl(parser, eh, new BuiltinDatatypeLibraryFactory(dlf), pb);
        final ParsedPatternFuture pf = parser.installHandlers(xr, sb, new RootScope(sb));
        return new PatternFuture(){

            @java.lang.Override
            public Pattern getPattern(boolean isAttributesPattern) throws IncorrectSchemaException, SAXException, IOException {
                try {
                    ParsedPattern pp = pf.getParsedPattern();
                    if (isAttributesPattern) {
                        pp = sb.wrapAttributesPattern(pp);
                    }
                    return sb.expandPattern((Pattern)pp);
                }
                catch (IllegalSchemaException e) {
                    throw new IncorrectSchemaException();
                }
                catch (BuildException e) {
                    throw SchemaBuilderImpl.unwrapBuildException(e);
                }
            }
        };
    }

    static RuntimeException unwrapBuildException(BuildException e) throws SAXException, IncorrectSchemaException, IOException {
        Throwable t = e.getCause();
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof IllegalSchemaException) {
            throw new IncorrectSchemaException();
        }
        if (t instanceof SAXException) {
            throw (SAXException)t;
        }
        if (t instanceof Exception) {
            throw new SAXException((Exception)t);
        }
        throw new SAXException(String.valueOf(t.getClass().getName()) + " thrown");
    }

    private ParsedPattern wrapAttributesPattern(ParsedPattern pattern) {
        return this.makeElement(this.makeAnyName(null, null), pattern, null, null);
    }

    private Pattern expandPattern(Pattern pattern) throws IllegalSchemaException, BuildException {
        if (!this.hadError) {
            try {
                pattern.checkRecursion(0);
                pattern = pattern.expand(this.pb);
                pattern.checkRestrictions(0, null, null);
                if (!this.hadError) {
                    return pattern;
                }
            }
            catch (SAXParseException e) {
                this.error(e);
            }
            catch (SAXException e) {
                throw new BuildException(e);
            }
            catch (RestrictionViolationException e) {
                if (e.getName() != null) {
                    this.error(e.getMessageId(), NameFormatter.format(e.getName()), e.getLocator());
                }
                this.error(e.getMessageId(), e.getLocator());
            }
        }
        throw new IllegalSchemaException();
    }

    private SchemaBuilderImpl(SubParser subParser, ErrorHandler eh, DatatypeLibraryFactory datatypeLibraryFactory, SchemaPatternBuilder pb) {
        this.parent = null;
        this.subParser = subParser;
        this.eh = eh;
        this.datatypeLibraryFactory = datatypeLibraryFactory;
        this.pb = pb;
        this.inheritNs = "";
        this.openIncludes = null;
    }

    private SchemaBuilderImpl(String inheritNs, String uri, SchemaBuilderImpl parent) {
        this.parent = parent;
        this.subParser = parent.subParser;
        this.eh = parent.eh;
        this.datatypeLibraryFactory = parent.datatypeLibraryFactory;
        this.pb = parent.pb;
        this.inheritNs = parent.resolveInherit(inheritNs);
        this.openIncludes = new OpenIncludes(uri, parent.openIncludes);
    }

    @java.lang.Override
    public ParsedPattern makeChoice(ParsedPattern[] patterns, int nPatterns, Location loc, Annotations anno) throws BuildException {
        if (nPatterns <= 0) {
            throw new IllegalArgumentException();
        }
        Pattern result = (Pattern)patterns[0];
        int i = 1;
        while (i < nPatterns) {
            result = this.pb.makeChoice(result, (Pattern)patterns[i]);
            ++i;
        }
        return result;
    }

    @java.lang.Override
    public ParsedPattern makeInterleave(ParsedPattern[] patterns, int nPatterns, Location loc, Annotations anno) throws BuildException {
        if (nPatterns <= 0) {
            throw new IllegalArgumentException();
        }
        Pattern result = (Pattern)patterns[0];
        int i = 1;
        while (i < nPatterns) {
            result = this.pb.makeInterleave(result, (Pattern)patterns[i]);
            ++i;
        }
        return result;
    }

    @java.lang.Override
    public ParsedPattern makeGroup(ParsedPattern[] patterns, int nPatterns, Location loc, Annotations anno) throws BuildException {
        if (nPatterns <= 0) {
            throw new IllegalArgumentException();
        }
        Pattern result = (Pattern)patterns[0];
        int i = 1;
        while (i < nPatterns) {
            result = this.pb.makeGroup(result, (Pattern)patterns[i]);
            ++i;
        }
        return result;
    }

    @java.lang.Override
    public ParsedPattern makeOneOrMore(ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeOneOrMore((Pattern)p);
    }

    @java.lang.Override
    public ParsedPattern makeZeroOrMore(ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeZeroOrMore((Pattern)p);
    }

    @java.lang.Override
    public ParsedPattern makeOptional(ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeOptional((Pattern)p);
    }

    @java.lang.Override
    public ParsedPattern makeList(ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeList((Pattern)p, (Locator)((Object)loc));
    }

    @java.lang.Override
    public ParsedPattern makeMixed(ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeMixed((Pattern)p);
    }

    @java.lang.Override
    public ParsedPattern makeEmpty(Location loc, Annotations anno) {
        return this.pb.makeEmpty();
    }

    @java.lang.Override
    public ParsedPattern makeNotAllowed(Location loc, Annotations anno) {
        return this.pb.makeUnexpandedNotAllowed();
    }

    @java.lang.Override
    public ParsedPattern makeText(Location loc, Annotations anno) {
        return this.pb.makeText();
    }

    @java.lang.Override
    public ParsedPattern makeErrorPattern() {
        return this.pb.makeError();
    }

    @java.lang.Override
    public ParsedNameClass makeErrorNameClass() {
        return new ErrorNameClass();
    }

    @java.lang.Override
    public ParsedPattern makeAttribute(ParsedNameClass nc, ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        String messageId = this.attributeNameClassChecker.checkNameClass((NameClass)nc);
        if (messageId != null) {
            this.error(messageId, (Locator)((Object)loc));
        }
        return this.pb.makeAttribute((NameClass)nc, (Pattern)p, (Locator)((Object)loc));
    }

    @java.lang.Override
    public ParsedPattern makeElement(ParsedNameClass nc, ParsedPattern p, Location loc, Annotations anno) throws BuildException {
        return this.pb.makeElement((NameClass)nc, (Pattern)p, (Locator)((Object)loc));
    }

    @java.lang.Override
    public DataPatternBuilder makeDataPatternBuilder(String datatypeLibrary, String type, Location loc) throws BuildException {
        DatatypeLibrary dl = this.datatypeLibraryFactory.createDatatypeLibrary(datatypeLibrary);
        if (dl == null) {
            this.error("unrecognized_datatype_library", datatypeLibrary, (Locator)((Object)loc));
        } else {
            try {
                return new DataPatternBuilderImpl(dl.createDatatypeBuilder(type));
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                if (detail != null) {
                    this.error("unsupported_datatype_detail", datatypeLibrary, type, detail, (Locator)((Object)loc));
                }
                this.error("unrecognized_datatype", datatypeLibrary, type, (Locator)((Object)loc));
            }
        }
        return new DummyDataPatternBuilder();
    }

    @java.lang.Override
    public ParsedPattern makeValue(String datatypeLibrary, String type, String value, Context context, String ns, Location loc, Annotations anno) throws BuildException {
        block8: {
            DatatypeLibrary dl = this.datatypeLibraryFactory.createDatatypeLibrary(datatypeLibrary);
            if (dl == null) {
                this.error("unrecognized_datatype_library", datatypeLibrary, (Locator)((Object)loc));
            } else {
                try {
                    DatatypeBuilder dtb = dl.createDatatypeBuilder(type);
                    try {
                        Datatype dt = dtb.createDatatype();
                        Object obj = dt.createValue(value, new ValidationContextImpl(context, ns));
                        if (obj != null) {
                            return this.pb.makeValue(dt, obj);
                        }
                        this.error("invalid_value", value, (Locator)((Object)loc));
                    }
                    catch (DatatypeException e) {
                        String detail = e.getMessage();
                        if (detail != null) {
                            this.error("datatype_requires_param_detail", detail, (Locator)((Object)loc));
                            break block8;
                        }
                        this.error("datatype_requires_param", (Locator)((Object)loc));
                    }
                }
                catch (DatatypeException e) {
                    this.error("unrecognized_datatype", datatypeLibrary, type, (Locator)((Object)loc));
                }
            }
        }
        return this.pb.makeError();
    }

    @java.lang.Override
    public Grammar makeGrammar(Scope parent) {
        return new GrammarImpl(this, parent);
    }

    @java.lang.Override
    public ParsedPattern annotate(ParsedPattern p, Annotations anno) throws BuildException {
        return p;
    }

    @java.lang.Override
    public ParsedNameClass annotate(ParsedNameClass nc, Annotations anno) throws BuildException {
        return nc;
    }

    @java.lang.Override
    public ParsedPattern annotateAfter(ParsedPattern p, ParsedElementAnnotation e) throws BuildException {
        return p;
    }

    @java.lang.Override
    public ParsedNameClass annotateAfter(ParsedNameClass nc, ParsedElementAnnotation e) throws BuildException {
        return nc;
    }

    @java.lang.Override
    public ParsedPattern commentAfter(ParsedPattern p, CommentList comments) throws BuildException {
        return p;
    }

    @java.lang.Override
    public ParsedNameClass commentAfter(ParsedNameClass nc, CommentList comments) throws BuildException {
        return nc;
    }

    @java.lang.Override
    public ParsedPattern makeExternalRef(String uri, String ns, Scope scope, Location loc, Annotations anno) throws BuildException {
        OpenIncludes inc = this.openIncludes;
        while (inc != null) {
            if (inc.uri.equals(uri)) {
                this.error("recursive_include", uri, (Locator)((Object)loc));
                return this.pb.makeError();
            }
            inc = inc.parent;
        }
        try {
            return this.subParser.parseExternal(uri, new SchemaBuilderImpl(ns, uri, this), scope);
        }
        catch (IllegalSchemaException e) {
            this.noteError();
            return this.pb.makeError();
        }
    }

    @java.lang.Override
    public ParsedNameClass makeChoice(ParsedNameClass[] nameClasses, int nNameClasses, Location loc, Annotations anno) {
        if (nNameClasses <= 0) {
            throw new IllegalArgumentException();
        }
        NameClass result = (NameClass)nameClasses[0];
        int i = 1;
        while (i < nNameClasses) {
            result = new ChoiceNameClass(result, (NameClass)nameClasses[i]);
            ++i;
        }
        return result;
    }

    @java.lang.Override
    public ParsedNameClass makeName(String ns, String localName, String prefix, Location loc, Annotations anno) {
        return new SimpleNameClass(new Name(this.resolveInherit(ns), localName));
    }

    @java.lang.Override
    public ParsedNameClass makeNsName(String ns, Location loc, Annotations anno) {
        return new NsNameClass(this.resolveInherit(ns));
    }

    @java.lang.Override
    public ParsedNameClass makeNsName(String ns, ParsedNameClass except, Location loc, Annotations anno) {
        return new NsNameExceptNameClass(this.resolveInherit(ns), (NameClass)except);
    }

    @java.lang.Override
    public ParsedNameClass makeAnyName(Location loc, Annotations anno) {
        return new AnyNameClass();
    }

    @java.lang.Override
    public ParsedNameClass makeAnyName(ParsedNameClass except, Location loc, Annotations anno) {
        return new AnyNameExceptNameClass((NameClass)except);
    }

    private final String resolveInherit(String ns) {
        if (ns == INHERIT_NS) {
            return this.inheritNs;
        }
        return ns;
    }

    @java.lang.Override
    public Location makeLocation(String systemId, int lineNumber, int columnNumber) {
        return new LocatorImpl(systemId, lineNumber, columnNumber);
    }

    @java.lang.Override
    public Annotations makeAnnotations(CommentList comments, Context context) {
        return this;
    }

    @java.lang.Override
    public ElementAnnotationBuilder makeElementAnnotationBuilder(String ns, String localName, String prefix, Location loc, CommentList comments, Context context) {
        return this;
    }

    @java.lang.Override
    public CommentList makeCommentList() {
        return this;
    }

    @java.lang.Override
    public void addComment(String value, Location loc) throws BuildException {
    }

    @java.lang.Override
    public void addAttribute(String ns, String localName, String prefix, String value, Location loc) {
    }

    @java.lang.Override
    public void addElement(ParsedElementAnnotation ea) {
    }

    @java.lang.Override
    public void addComment(CommentList comments) throws BuildException {
    }

    @java.lang.Override
    public void addLeadingComment(CommentList comments) throws BuildException {
    }

    @java.lang.Override
    public void addText(String value, Location loc, CommentList comments) {
    }

    @java.lang.Override
    public ParsedElementAnnotation makeElementAnnotation() {
        return null;
    }

    @java.lang.Override
    public boolean usesComments() {
        return false;
    }

    private void error(SAXParseException message) throws BuildException {
        this.noteError();
        try {
            if (this.eh != null) {
                this.eh.error(message);
            }
        }
        catch (SAXException e) {
            throw new BuildException(e);
        }
    }

    private void error(String key, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key), loc));
    }

    private void error(String key, String arg, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key, arg), loc));
    }

    private void error(String key, String arg1, String arg2, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key, arg1, arg2), loc));
    }

    private void error(String key, String arg1, String arg2, String arg3, Locator loc) throws BuildException {
        this.error(new SAXParseException(localizer.message(key, new Object[]{arg1, arg2, arg3}), loc));
    }

    private void noteError() {
        if (!this.hadError && this.parent != null) {
            this.parent.noteError();
        }
        this.hadError = true;
    }

    static /* synthetic */ OpenIncludes access$5(SchemaBuilderImpl schemaBuilderImpl) {
        return schemaBuilderImpl.openIncludes;
    }

    /* synthetic */ SchemaBuilderImpl(String string, String string2, SchemaBuilderImpl schemaBuilderImpl, SchemaBuilderImpl schemaBuilderImpl2) {
        this(string, string2, schemaBuilderImpl);
    }

    static /* synthetic */ SubParser access$7(SchemaBuilderImpl schemaBuilderImpl) {
        return schemaBuilderImpl.subParser;
    }

    static /* synthetic */ void access$8(SchemaBuilderImpl schemaBuilderImpl) {
        schemaBuilderImpl.noteError();
    }

    private class DataPatternBuilderImpl
    implements DataPatternBuilder {
        private final DatatypeBuilder dtb;

        DataPatternBuilderImpl(DatatypeBuilder dtb) {
            this.dtb = dtb;
        }

        @java.lang.Override
        public void addParam(String name, String value, Context context, String ns, Location loc, Annotations anno) throws BuildException {
            try {
                this.dtb.addParameter(name, value, new ValidationContextImpl(context, ns));
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                int pos = e.getIndex();
                String displayedParam = pos == -1 ? null : this.displayParam(value, pos);
                if (displayedParam != null) {
                    if (detail != null) {
                        SchemaBuilderImpl.this.error("invalid_param_detail_display", detail, displayedParam, (Locator)((Object)loc));
                    } else {
                        SchemaBuilderImpl.this.error("invalid_param_display", displayedParam, (Locator)((Object)loc));
                    }
                }
                if (detail != null) {
                    SchemaBuilderImpl.this.error("invalid_param_detail", detail, (Locator)((Object)loc));
                }
                SchemaBuilderImpl.this.error("invalid_param", (Locator)((Object)loc));
            }
        }

        @java.lang.Override
        public void annotation(ParsedElementAnnotation ea) throws BuildException {
        }

        String displayParam(String value, int pos) {
            if (pos < 0) {
                pos = 0;
            } else if (pos > value.length()) {
                pos = value.length();
            }
            return localizer.message("display_param", value.substring(0, pos), value.substring(pos));
        }

        @java.lang.Override
        public ParsedPattern makePattern(Location loc, Annotations anno) throws BuildException {
            try {
                return SchemaBuilderImpl.this.pb.makeData(this.dtb.createDatatype());
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                if (detail != null) {
                    SchemaBuilderImpl.this.error("invalid_params_detail", detail, (Locator)((Object)loc));
                } else {
                    SchemaBuilderImpl.this.error("invalid_params", (Locator)((Object)loc));
                }
                return SchemaBuilderImpl.this.pb.makeError();
            }
        }

        @java.lang.Override
        public ParsedPattern makePattern(ParsedPattern except, Location loc, Annotations anno) throws BuildException {
            try {
                return SchemaBuilderImpl.this.pb.makeDataExcept(this.dtb.createDatatype(), (Pattern)except, (Locator)((Object)loc));
            }
            catch (DatatypeException e) {
                String detail = e.getMessage();
                if (detail != null) {
                    SchemaBuilderImpl.this.error("invalid_params_detail", detail, (Locator)((Object)loc));
                } else {
                    SchemaBuilderImpl.this.error("invalid_params", (Locator)((Object)loc));
                }
                return SchemaBuilderImpl.this.pb.makeError();
            }
        }
    }

    private class DummyDataPatternBuilder
    implements DataPatternBuilder {
        private DummyDataPatternBuilder() {
        }

        @java.lang.Override
        public void addParam(String name, String value, Context context, String ns, Location loc, Annotations anno) throws BuildException {
        }

        @java.lang.Override
        public void annotation(ParsedElementAnnotation ea) throws BuildException {
        }

        @java.lang.Override
        public ParsedPattern makePattern(Location loc, Annotations anno) throws BuildException {
            return SchemaBuilderImpl.this.pb.makeError();
        }

        @java.lang.Override
        public ParsedPattern makePattern(ParsedPattern except, Location loc, Annotations anno) throws BuildException {
            return SchemaBuilderImpl.this.pb.makeError();
        }
    }

    static class GrammarImpl
    implements Grammar,
    Div,
    IncludedGrammar {
        private final SchemaBuilderImpl sb;
        private final Hashtable defines;
        private final RefPattern startRef;
        private final Scope parent;

        private GrammarImpl(SchemaBuilderImpl sb, Scope parent) {
            this.sb = sb;
            this.parent = parent;
            this.defines = new Hashtable();
            this.startRef = new RefPattern(null);
        }

        protected GrammarImpl(SchemaBuilderImpl sb, GrammarImpl g) {
            this.sb = sb;
            this.parent = g.parent;
            this.startRef = g.startRef;
            this.defines = g.defines;
        }

        @java.lang.Override
        public ParsedPattern endGrammar(Location loc, Annotations anno) throws BuildException {
            Enumeration enumList = this.defines.keys();
            while (enumList.hasMoreElements()) {
                String name = (String)enumList.nextElement();
                RefPattern rp = (RefPattern)this.defines.get(name);
                if (rp.getPattern() != null) continue;
                this.sb.error("reference_to_undefined", name, rp.getRefLocator());
                rp.setPattern(this.sb.pb.makeError());
            }
            Pattern start = this.startRef.getPattern();
            if (start == null) {
                this.sb.error("missing_start_element", (Locator)((Object)loc));
                start = this.sb.pb.makeError();
            }
            return start;
        }

        @java.lang.Override
        public void endDiv(Location loc, Annotations anno) throws BuildException {
        }

        @java.lang.Override
        public ParsedPattern endIncludedGrammar(Location loc, Annotations anno) throws BuildException {
            return null;
        }

        @java.lang.Override
        public void define(String name, GrammarSection.Combine combine, ParsedPattern pattern, Location loc, Annotations anno) throws BuildException {
            this.define(this.lookup(name), combine, pattern, loc);
        }

        private void define(RefPattern rp, GrammarSection.Combine combine, ParsedPattern pattern, Location loc) throws BuildException {
            switch (rp.getReplacementStatus()) {
                case 0: {
                    if (combine == null) {
                        if (rp.isCombineImplicit()) {
                            if (rp.getName() == null) {
                                this.sb.error("duplicate_start", (Locator)((Object)loc));
                            } else {
                                this.sb.error("duplicate_define", rp.getName(), (Locator)((Object)loc));
                            }
                        } else {
                            rp.setCombineImplicit();
                        }
                    } else {
                        byte combineType;
                        byte by = combineType = combine == COMBINE_CHOICE ? (byte)1 : 2;
                        if (rp.getCombineType() != 0 && rp.getCombineType() != combineType) {
                            if (rp.getName() == null) {
                                this.sb.error("conflict_combine_start", (Locator)((Object)loc));
                            } else {
                                this.sb.error("conflict_combine_define", rp.getName(), (Locator)((Object)loc));
                            }
                        }
                        rp.setCombineType(combineType);
                    }
                    Pattern p = (Pattern)pattern;
                    if (rp.getPattern() == null) {
                        rp.setPattern(p);
                        break;
                    }
                    if (rp.getCombineType() == 2) {
                        rp.setPattern(this.sb.pb.makeInterleave(rp.getPattern(), p));
                        break;
                    }
                    rp.setPattern(this.sb.pb.makeChoice(rp.getPattern(), p));
                    break;
                }
                case 1: {
                    rp.setReplacementStatus((byte)2);
                    break;
                }
            }
        }

        @java.lang.Override
        public void topLevelAnnotation(ParsedElementAnnotation ea) throws BuildException {
        }

        @java.lang.Override
        public void topLevelComment(CommentList comments) throws BuildException {
        }

        private RefPattern lookup(String name) {
            if (name == START) {
                return this.startRef;
            }
            return this.lookup1(name);
        }

        private RefPattern lookup1(String name) {
            RefPattern p = (RefPattern)this.defines.get(name);
            if (p == null) {
                p = new RefPattern(name);
                this.defines.put(name, p);
            }
            return p;
        }

        @java.lang.Override
        public ParsedPattern makeRef(String name, Location loc, Annotations anno) throws BuildException {
            RefPattern p = this.lookup1(name);
            if (p.getRefLocator() == null && loc != null) {
                p.setRefLocator((Locator)((Object)loc));
            }
            return p;
        }

        @java.lang.Override
        public ParsedPattern makeParentRef(String name, Location loc, Annotations anno) throws BuildException {
            if (this.parent == null) {
                this.sb.error("parent_ref_outside_grammar", (Locator)((Object)loc));
                return this.sb.makeErrorPattern();
            }
            return this.parent.makeRef(name, loc, anno);
        }

        @java.lang.Override
        public Div makeDiv() {
            return this;
        }

        @java.lang.Override
        public Include makeInclude() {
            return new IncludeImpl(this.sb, this);
        }
    }

    private static class IncludeImpl
    implements Include,
    Div {
        private final SchemaBuilderImpl sb;
        private Override overrides;
        private final GrammarImpl grammar;

        private IncludeImpl(SchemaBuilderImpl sb, GrammarImpl grammar) {
            this.sb = sb;
            this.grammar = grammar;
        }

        @java.lang.Override
        public void define(String name, GrammarSection.Combine combine, ParsedPattern pattern, Location loc, Annotations anno) throws BuildException {
            RefPattern rp = this.grammar.lookup(name);
            this.overrides = new Override(rp, this.overrides);
            this.grammar.define(rp, combine, pattern, loc);
        }

        @java.lang.Override
        public void endDiv(Location loc, Annotations anno) throws BuildException {
        }

        @java.lang.Override
        public void topLevelAnnotation(ParsedElementAnnotation ea) throws BuildException {
        }

        @java.lang.Override
        public void topLevelComment(CommentList comments) throws BuildException {
        }

        @java.lang.Override
        public Div makeDiv() {
            return this;
        }

        /*
         * Unable to fully structure code
         */
        @java.lang.Override
        public void endInclude(String uri, String ns, Location loc, Annotations anno) throws BuildException {
            block15: {
                block14: {
                    inc = SchemaBuilderImpl.access$5(this.sb);
                    while (inc != null) {
                        if (inc.uri.equals(uri)) {
                            SchemaBuilderImpl.access$3(this.sb, "recursive_include", uri, (Locator)loc);
                            return;
                        }
                        inc = inc.parent;
                    }
                    o = this.overrides;
                    while (o != null) {
                        o.replacementStatus = o.prp.getReplacementStatus();
                        o.prp.setReplacementStatus((byte)1);
                        o = o.next;
                    }
                    try {
                        try {
                            isb = new SchemaBuilderImpl(ns, uri, this.sb, null);
                            SchemaBuilderImpl.access$7(this.sb).parseInclude(uri, isb, new GrammarImpl(isb, this.grammar));
                            o = this.overrides;
                            while (o != null) {
                                if (o.prp.getReplacementStatus() == 1) {
                                    if (o.prp.getName() == null) {
                                        SchemaBuilderImpl.access$4(this.sb, "missing_start_replacement", (Locator)loc);
                                    } else {
                                        SchemaBuilderImpl.access$3(this.sb, "missing_define_replacement", o.prp.getName(), (Locator)loc);
                                    }
                                }
                                o = o.next;
                            }
                            break block14;
                        }
                        catch (IllegalSchemaException e) {
                            SchemaBuilderImpl.access$8(this.sb);
                            o = this.overrides;
                            ** while (o != null)
                        }
                    }
                    catch (Throwable var7_11) {
                        o = this.overrides;
                        ** while (o != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        o.prp.setReplacementStatus(o.replacementStatus);
                        o = o.next;
                        continue;
lbl36:
                        // 1 sources

                        break block15;
                    }
lbl-1000:
                    // 1 sources

                    {
                        o.prp.setReplacementStatus(o.replacementStatus);
                        o = o.next;
                        continue;
                    }
lbl43:
                    // 1 sources

                    throw var7_11;
                }
                o = this.overrides;
                while (o != null) {
                    o.prp.setReplacementStatus(o.replacementStatus);
                    o = o.next;
                }
            }
        }

        @java.lang.Override
        public Include makeInclude() {
            return null;
        }
    }

    private class LocatorImpl
    implements Locator,
    Location {
        private final String systemId;
        private final int lineNumber;
        private final int columnNumber;

        private LocatorImpl(String systemId, int lineNumber, int columnNumber) {
            this.systemId = systemId;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        @java.lang.Override
        public String getPublicId() {
            return null;
        }

        @java.lang.Override
        public String getSystemId() {
            return this.systemId;
        }

        @java.lang.Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @java.lang.Override
        public int getColumnNumber() {
            return this.columnNumber;
        }
    }

    static class OpenIncludes {
        final String uri;
        final OpenIncludes parent;

        OpenIncludes(String uri, OpenIncludes parent) {
            this.uri = uri;
            this.parent = parent;
        }
    }

    static class Override {
        final RefPattern prp;
        final Override next;
        byte replacementStatus;

        Override(RefPattern prp, Override next) {
            this.prp = prp;
            this.next = next;
        }
    }

    static class RootScope
    implements Scope {
        private final SchemaBuilderImpl sb;

        RootScope(SchemaBuilderImpl sb) {
            this.sb = sb;
        }

        @java.lang.Override
        public ParsedPattern makeParentRef(String name, Location loc, Annotations anno) throws BuildException {
            this.sb.error("parent_ref_outside_grammar", (Locator)((Object)loc));
            return this.sb.makeErrorPattern();
        }

        @java.lang.Override
        public ParsedPattern makeRef(String name, Location loc, Annotations anno) throws BuildException {
            this.sb.error("ref_outside_grammar", (Locator)((Object)loc));
            return this.sb.makeErrorPattern();
        }
    }

    private class ValidationContextImpl
    implements ValidationContext {
        private final ValidationContext vc;
        private final String ns;

        ValidationContextImpl(ValidationContext vc, String ns) {
            this.vc = vc;
            this.ns = ns.length() == 0 ? null : ns;
        }

        @java.lang.Override
        public String resolveNamespacePrefix(String prefix) {
            String result;
            String string = result = prefix.length() == 0 ? this.ns : this.vc.resolveNamespacePrefix(prefix);
            if (result == INHERIT_NS) {
                if (SchemaBuilderImpl.this.inheritNs.length() == 0) {
                    return null;
                }
                return SchemaBuilderImpl.this.inheritNs;
            }
            return result;
        }

        @java.lang.Override
        public String getBaseUri() {
            return this.vc.getBaseUri();
        }

        @java.lang.Override
        public boolean isUnparsedEntity(String entityName) {
            return this.vc.isUnparsedEntity(entityName);
        }

        @java.lang.Override
        public boolean isNotation(String notationName) {
            return this.vc.isNotation(notationName);
        }
    }
}

