/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.ApplyAfterFunction;
import com.thaiopensource.relaxng.impl.FindElementFunction;
import com.thaiopensource.relaxng.impl.NameFormatter;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.parse.sax.DtdContext;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.util.Name;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PatternValidator
extends DtdContext
implements Validator,
ContentHandler,
DTDHandler {
    private final ValidatorPatternBuilder builder;
    private final Pattern start;
    private final ErrorHandler eh;
    private Hashtable recoverPatternTable;
    private PatternMemo memo;
    private boolean hadError;
    private boolean collectingCharacters;
    private final StringBuffer charBuf = new StringBuffer();
    private PrefixMapping prefixMapping = new PrefixMapping("xml", "http://www.w3.org/XML/1998/namespace", null);
    private Locator locator;

    private void startCollectingCharacters() {
        if (!this.collectingCharacters) {
            this.collectingCharacters = true;
            this.charBuf.setLength(0);
        }
    }

    private void flushCharacters() throws SAXException {
        this.collectingCharacters = false;
        int len = this.charBuf.length();
        int i = 0;
        while (i < len) {
            switch (this.charBuf.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    this.text();
                    return;
                }
            }
            ++i;
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Name name;
        if (this.collectingCharacters) {
            this.flushCharacters();
        }
        if (!this.setMemo(this.memo.startTagOpenDeriv(name = new Name(namespaceURI, localName)))) {
            PatternMemo next = this.memo.startTagOpenRecoverDeriv(name);
            if (!next.isNotAllowed()) {
                this.error("required_elements_missing");
            } else {
                next = this.builder.getPatternMemo(this.builder.makeAfter(this.findElement(name), this.memo.getPattern()));
                this.error(next.isNotAllowed() ? "unknown_element" : "out_of_context_element", name);
            }
            this.memo = next;
        }
        int len = atts.getLength();
        int i = 0;
        while (i < len) {
            Name attName = new Name(atts.getURI(i), atts.getLocalName(i));
            if (!this.setMemo(this.memo.startAttributeDeriv(attName))) {
                this.error("impossible_attribute_ignored", attName);
            } else if (!this.setMemo(this.memo.dataDeriv(atts.getValue(i), this))) {
                this.error("bad_attribute_value", attName);
                this.memo = this.memo.recoverAfter();
            }
            ++i;
        }
        if (!this.setMemo(this.memo.endAttributes())) {
            this.error("required_attributes_missing");
            this.memo = this.memo.ignoreMissingAttributes();
        }
        if (this.memo.getPattern().getContentType() == 3) {
            this.startCollectingCharacters();
        }
    }

    private PatternMemo fixAfter(PatternMemo p) {
        return this.builder.getPatternMemo(p.getPattern().applyForPattern(new ApplyAfterFunction(this.builder){

            @Override
            Pattern apply(Pattern p) {
                return PatternValidator.this.builder.makeEmpty();
            }
        }));
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.collectingCharacters) {
            this.collectingCharacters = false;
            if (!this.setMemo(this.memo.textOnly())) {
                this.error("only_text_not_allowed");
                this.memo = this.memo.recoverAfter();
                return;
            }
            String data = this.charBuf.toString();
            if (!this.setMemo(this.memo.dataDeriv(data, this))) {
                PatternMemo next = this.memo.recoverAfter();
                if (!(this.memo.isNotAllowed() || next.isNotAllowed() && !this.fixAfter(this.memo).dataDeriv(data, this).isNotAllowed())) {
                    this.error("string_not_allowed");
                }
                this.memo = next;
            }
        } else if (!this.setMemo(this.memo.endTagDeriv())) {
            PatternMemo next = this.memo.recoverAfter();
            if (!(this.memo.isNotAllowed() || next.isNotAllowed() && !this.fixAfter(this.memo).endTagDeriv().isNotAllowed())) {
                this.error("unfinished_element");
            }
            this.memo = next;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.collectingCharacters) {
            this.charBuf.append(ch, start, length);
            return;
        }
        int i = 0;
        while (i < length) {
            switch (ch[start + i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    this.text();
                    return;
                }
            }
            ++i;
        }
    }

    private void text() throws SAXException {
        if (!this.setMemo(this.memo.mixedTextDeriv())) {
            this.error("text_not_allowed");
        }
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.memo.isNotAllowed()) {
            this.error("schema_allows_nothing");
        }
    }

    @Override
    public void processingInstruction(String target, String date) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int len) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.prefixMapping = new PrefixMapping(prefix, uri, this.prefixMapping);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.prefixMapping = this.prefixMapping.getPrevious();
    }

    public PatternValidator(Pattern pattern, ValidatorPatternBuilder builder, ErrorHandler eh) {
        this.start = pattern;
        this.builder = builder;
        this.eh = eh;
        this.reset();
    }

    @Override
    public void reset() {
        this.hadError = false;
        this.collectingCharacters = false;
        this.locator = null;
        this.memo = this.builder.getPatternMemo(this.start);
        this.prefixMapping = new PrefixMapping("xml", "http://www.w3.org/XML/1998/namespace", null);
        this.clearDtdContext();
    }

    @Override
    public ContentHandler getContentHandler() {
        return this;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this;
    }

    private void error(String key) throws SAXException {
        if (this.hadError && this.memo.isNotAllowed()) {
            return;
        }
        this.hadError = true;
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key), this.locator));
    }

    private void error(String key, Name arg) throws SAXException {
        this.error(key, NameFormatter.format(arg));
    }

    private void error(String key, String arg) throws SAXException {
        if (this.hadError && this.memo.isNotAllowed()) {
            return;
        }
        this.hadError = true;
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key, arg), this.locator));
    }

    private boolean setMemo(PatternMemo m) {
        if (m.isNotAllowed()) {
            return false;
        }
        this.memo = m;
        return true;
    }

    private Pattern findElement(Name name) {
        Pattern p;
        if (this.recoverPatternTable == null) {
            this.recoverPatternTable = new Hashtable();
        }
        if ((p = (Pattern)this.recoverPatternTable.get(name)) == null) {
            p = FindElementFunction.findElement(this.builder, name, this.start);
            this.recoverPatternTable.put(name, p);
        }
        return p;
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        PrefixMapping tem = this.prefixMapping;
        do {
            if (!tem.prefix.equals(prefix)) continue;
            return tem.namespaceURI;
        } while ((tem = tem.previous) != null);
        return null;
    }

    @Override
    public String getBaseUri() {
        return null;
    }

    private static final class PrefixMapping {
        private final String prefix;
        private final String namespaceURI;
        private final PrefixMapping previous;

        PrefixMapping(String prefix, String namespaceURI, PrefixMapping prev) {
            this.prefix = prefix;
            this.namespaceURI = namespaceURI;
            this.previous = prev;
        }

        PrefixMapping getPrevious() {
            return this.previous;
        }
    }
}

