/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.xml.util.Name;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.relaxng.datatype.Datatype;

public class PatternDumper {
    private boolean startTagOpen = false;
    private final Vector tagStack = new Vector();
    private final PrintWriter writer;
    private int level = 0;
    private boolean suppressIndent = false;
    private final Vector patternList = new Vector();
    private final Hashtable patternTable = new Hashtable();
    private final PatternVisitor patternVisitor = new DumpPatternVisitor();
    private final PatternVisitor groupPatternVisitor = new GroupDumpPatternVisitor();
    private final PatternVisitor choicePatternVisitor = new ChoiceDumpPatternVisitor();
    private final PatternVisitor interleavePatternVisitor = new InterleaveDumpPatternVisitor();
    private final NameClassVisitor nameClassVisitor = new DumpNameClassVisitor();
    private final NameClassVisitor choiceNameClassVisitor = new ChoiceDumpNameClassVisitor();

    public static void dump(PrintWriter writer, Pattern p) {
        new PatternDumper(writer).dump(p);
    }

    public static void dump(OutputStream out, Pattern p) {
        new PatternDumper(new PrintWriter(out)).dump(p);
    }

    private PatternDumper(PrintWriter writer) {
        this.writer = writer;
    }

    private void dump(Pattern p) {
        this.write("<?xml version=\"1.0\"?>");
        this.startElement("grammar");
        this.attribute("xmlns", "http://relaxng.org/ns/structure/1.0");
        this.startElement("start");
        p.accept(this.groupPatternVisitor);
        this.endElement();
        int i = 0;
        while (i < this.patternList.size()) {
            this.startElement("define");
            Pattern tem = (Pattern)this.patternList.elementAt(i);
            this.attribute("name", this.getName(tem));
            tem.accept(this.groupPatternVisitor);
            this.endElement();
            ++i;
        }
        this.endElement();
        this.writer.println();
        this.writer.flush();
    }

    private String getName(Pattern p) {
        String name = (String)this.patternTable.get(p);
        if (name == null) {
            name = "p" + this.patternList.size();
            this.patternList.addElement(p);
            this.patternTable.put(p, name);
        }
        return name;
    }

    private void startElement(String name) {
        this.closeStartTag();
        this.indent(this.level);
        this.write('<');
        this.write(name);
        this.push(name);
        this.startTagOpen = true;
        ++this.level;
    }

    private void closeStartTag() {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write('>');
        }
    }

    private void attribute(String name, String value) {
        this.write(' ');
        this.write(name);
        this.write('=');
        this.write('\"');
        this.chars(value, true);
        this.write('\"');
    }

    private void data(String str) {
        if (str.length() > 0) {
            this.closeStartTag();
            this.chars(str, false);
            this.suppressIndent = true;
        }
    }

    private void chars(String str, boolean isAttribute) {
        int len = str.length();
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    this.write("&amp;");
                    break;
                }
                case '<': {
                    this.write("&lt;");
                    break;
                }
                case '>': {
                    this.write("&gt;");
                    break;
                }
                case '\"': {
                    if (isAttribute) {
                        this.write("&quot;");
                        break;
                    }
                }
                default: {
                    this.write(c);
                }
            }
            ++i;
        }
    }

    private void endElement() {
        --this.level;
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write("/>");
            this.pop();
        } else {
            if (!this.suppressIndent) {
                this.indent(this.level);
            }
            this.write("</");
            this.write(this.pop());
            this.write(">");
        }
        this.suppressIndent = false;
    }

    private void indent(int level) {
        this.writer.println();
        int i = 0;
        while (i < level) {
            this.write("  ");
            ++i;
        }
    }

    private void write(String str) {
        this.writer.print(str);
    }

    private void write(char c) {
        this.writer.print(c);
    }

    private void push(String s) {
        this.tagStack.addElement(s);
    }

    private String pop() {
        String s = (String)this.tagStack.lastElement();
        this.tagStack.setSize(this.tagStack.size() - 1);
        return s;
    }

    class ChoiceDumpNameClassVisitor
    extends DumpNameClassVisitor {
        ChoiceDumpNameClassVisitor() {
        }

        @Override
        public void visitChoice(NameClass nc1, NameClass nc2) {
            nc1.accept(this);
            nc2.accept(this);
        }
    }

    class ChoiceDumpPatternVisitor
    extends DumpPatternVisitor {
        ChoiceDumpPatternVisitor() {
        }

        @Override
        public void visitChoice(Pattern p1, Pattern p2) {
            p1.accept(this);
            p2.accept(this);
        }
    }

    class DumpNameClassVisitor
    implements NameClassVisitor {
        DumpNameClassVisitor() {
        }

        @Override
        public void visitChoice(NameClass nc1, NameClass nc2) {
            PatternDumper.this.startElement("choice");
            nc1.accept(PatternDumper.this.choiceNameClassVisitor);
            nc2.accept(PatternDumper.this.choiceNameClassVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitNsName(String ns) {
            PatternDumper.this.startElement("nsName");
            PatternDumper.this.attribute("ns", ns);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitNsNameExcept(String ns, NameClass nc) {
            PatternDumper.this.startElement("nsName");
            PatternDumper.this.startElement("except");
            nc.accept(PatternDumper.this.choiceNameClassVisitor);
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
        }

        @Override
        public void visitAnyName() {
            PatternDumper.this.startElement("anyName");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitAnyNameExcept(NameClass nc) {
            PatternDumper.this.startElement("anyName");
            PatternDumper.this.startElement("except");
            nc.accept(PatternDumper.this.choiceNameClassVisitor);
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
        }

        @Override
        public void visitName(Name name) {
            PatternDumper.this.startElement("name");
            PatternDumper.this.attribute("ns", name.getNamespaceUri());
            PatternDumper.this.data(name.getLocalName());
            PatternDumper.this.endElement();
        }

        @Override
        public void visitError() {
            PatternDumper.this.startElement("error");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitNull() {
            this.visitAnyName();
        }
    }

    class DumpPatternVisitor
    implements PatternVisitor {
        DumpPatternVisitor() {
        }

        @Override
        public void visitEmpty() {
            PatternDumper.this.startElement("empty");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitNotAllowed() {
            PatternDumper.this.startElement("notAllowed");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitError() {
            PatternDumper.this.startElement("error");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitGroup(Pattern p1, Pattern p2) {
            PatternDumper.this.startElement("group");
            p1.accept(PatternDumper.this.groupPatternVisitor);
            p2.accept(PatternDumper.this.groupPatternVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitInterleave(Pattern p1, Pattern p2) {
            PatternDumper.this.startElement("interleave");
            p1.accept(PatternDumper.this.interleavePatternVisitor);
            p2.accept(PatternDumper.this.interleavePatternVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitChoice(Pattern p1, Pattern p2) {
            PatternDumper.this.startElement("choice");
            p1.accept(PatternDumper.this.choicePatternVisitor);
            p2.accept(PatternDumper.this.choicePatternVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitOneOrMore(Pattern p) {
            PatternDumper.this.startElement("oneOrMore");
            p.accept(PatternDumper.this.groupPatternVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitElement(NameClass nc, Pattern content) {
            PatternDumper.this.startElement("element");
            nc.accept(PatternDumper.this.nameClassVisitor);
            PatternDumper.this.startElement("ref");
            PatternDumper.this.attribute("name", PatternDumper.this.getName(content));
            PatternDumper.this.endElement();
            PatternDumper.this.endElement();
        }

        @Override
        public void visitAttribute(NameClass nc, Pattern value) {
            PatternDumper.this.startElement("attribute");
            nc.accept(PatternDumper.this.nameClassVisitor);
            value.accept(PatternDumper.this.patternVisitor);
            PatternDumper.this.endElement();
        }

        @Override
        public void visitData(Datatype dt) {
            PatternDumper.this.startElement("text");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitDataExcept(Datatype dt, Pattern except) {
            PatternDumper.this.startElement("text");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitValue(Datatype dt, Object obj) {
            PatternDumper.this.startElement("value");
            PatternDumper.this.data(obj.toString());
            PatternDumper.this.endElement();
        }

        @Override
        public void visitText() {
            PatternDumper.this.startElement("text");
            PatternDumper.this.endElement();
        }

        @Override
        public void visitList(Pattern p) {
            PatternDumper.this.startElement("list");
            p.accept(PatternDumper.this.groupPatternVisitor);
            PatternDumper.this.endElement();
        }
    }

    class GroupDumpPatternVisitor
    extends DumpPatternVisitor {
        GroupDumpPatternVisitor() {
        }

        @Override
        public void visitGroup(Pattern p1, Pattern p2) {
            p1.accept(this);
            p2.accept(this);
        }
    }

    class InterleaveDumpPatternVisitor
    extends DumpPatternVisitor {
        InterleaveDumpPatternVisitor() {
        }

        @Override
        public void visitInterleave(Pattern p1, Pattern p2) {
            p1.accept(this);
            p2.accept(this);
        }
    }
}

