/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class ListPattern
extends Pattern {
    private final Pattern p;
    private final Locator locator;

    ListPattern(Pattern p, Locator locator) {
        super(false, 3, ListPattern.combineHashCode(37, p.hashCode()));
        this.p = p;
        this.locator = locator;
    }

    @Override
    Pattern expand(SchemaPatternBuilder b) {
        Pattern ep = this.p.expand(b);
        if (ep != this.p) {
            return b.makeList(ep, this.locator);
        }
        return this;
    }

    @Override
    void checkRecursion(int depth) throws SAXException {
        this.p.checkRecursion(depth);
    }

    @Override
    boolean samePattern(Pattern other) {
        return other instanceof ListPattern && this.p == ((ListPattern)other).p;
    }

    @Override
    void accept(PatternVisitor visitor) {
        visitor.visitList(this.p);
    }

    @Override
    Object apply(PatternFunction f) {
        return f.caseList(this);
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        switch (context) {
            case 7: {
                throw new RestrictionViolationException("data_except_contains_list");
            }
            case 0: {
                throw new RestrictionViolationException("start_contains_list");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_list");
            }
        }
        try {
            this.p.checkRestrictions(6, dad, null);
        }
        catch (RestrictionViolationException e) {
            e.maybeSetLocator(this.locator);
            throw e;
        }
    }

    Pattern getOperand() {
        return this.p;
    }
}

