/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.util.Name;
import com.thaiopensource.xml.util.StringSplitter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class IdSoundnessChecker
implements Validator,
ContentHandler {
    private final IdTypeMap idTypeMap;
    private final ErrorHandler eh;
    private Locator locator;
    private final Hashtable table = new Hashtable();

    public IdSoundnessChecker(IdTypeMap idTypeMap, ErrorHandler eh) {
        this.idTypeMap = idTypeMap;
        this.eh = eh;
    }

    @Override
    public void reset() {
        this.table.clear();
        this.locator = null;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    void setComplete() {
    }

    @Override
    public void endDocument() throws SAXException {
        Enumeration e = this.table.keys();
        while (e.hasMoreElements()) {
            String token = (String)e.nextElement();
            Entry entry = (Entry)this.table.get(token);
            if (entry.hadId) continue;
            Enumeration f = entry.idrefLocs.elements();
            while (f.hasMoreElements()) {
                this.error("missing_id", token, (Locator)f.nextElement());
            }
        }
        this.setComplete();
    }

    @Override
    public void startPrefixMapping(String s, String s1) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String s) throws SAXException {
    }

    @Override
    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        Name elementName = new Name(namespaceUri, localName);
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            Name attributeName = new Name(attributes.getURI(i), attributes.getLocalName(i));
            int idType = this.idTypeMap.getIdType(elementName, attributeName);
            if (idType != 0) {
                String[] tokens = StringSplitter.split(attributes.getValue(i));
                switch (idType) {
                    case 1: {
                        if (tokens.length == 1) {
                            this.id(tokens[0]);
                            break;
                        }
                        if (tokens.length == 0) {
                            this.error("id_no_tokens");
                            break;
                        }
                        this.error("id_multiple_tokens");
                        break;
                    }
                    case 2: {
                        if (tokens.length == 1) {
                            this.idref(tokens[0]);
                            break;
                        }
                        if (tokens.length == 0) {
                            this.error("idref_no_tokens");
                            break;
                        }
                        this.error("idref_multiple_tokens");
                        break;
                    }
                    case 3: {
                        if (tokens.length > 0) {
                            int j = 0;
                            while (j < tokens.length) {
                                this.idref(tokens[j]);
                                ++j;
                            }
                            break;
                        }
                        this.error("idrefs_no_tokens");
                    }
                }
            }
            ++i;
        }
    }

    private void id(String token) throws SAXException {
        Entry entry = (Entry)this.table.get(token);
        if (entry == null) {
            entry = new Entry();
            this.table.put(token, entry);
        } else if (entry.hadId) {
            this.error("duplicate_id", token);
            this.error("first_id", token, entry.idLoc);
            return;
        }
        entry.idLoc = new LocatorImpl(this.locator);
        entry.hadId = true;
    }

    private void idref(String token) {
        Entry entry = (Entry)this.table.get(token);
        if (entry == null) {
            entry = new Entry();
            this.table.put(token, entry);
        }
        if (entry.hadId) {
            return;
        }
        if (entry.idrefLocs == null) {
            entry.idrefLocs = new Vector();
        }
        entry.idrefLocs.addElement(new LocatorImpl(this.locator));
    }

    @Override
    public void endElement(String s, String s1, String s2) throws SAXException {
    }

    @Override
    public void characters(char[] chars, int i, int i1) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
    }

    @Override
    public void processingInstruction(String s, String s1) throws SAXException {
    }

    @Override
    public void skippedEntity(String s) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    private void error(String key) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key), this.locator));
    }

    private void error(String key, String arg) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key, arg), this.locator));
    }

    private void error(String key, String arg, Locator loc) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key, arg), loc));
    }

    private static class Entry {
        Locator idLoc;
        Vector idrefLocs;
        boolean hadId;

        private Entry() {
        }
    }
}

