/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.BinaryPattern;
import com.thaiopensource.relaxng.impl.BlankDataDerivType;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataDataDerivType;
import com.thaiopensource.relaxng.impl.DataDerivType;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.SingleDataDerivType;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.impl.ValueDataDerivType;
import com.thaiopensource.relaxng.impl.ValuePattern;

class DataDerivTypeFunction
extends AbstractPatternFunction {
    private final ValidatorPatternBuilder builder;

    DataDerivTypeFunction(ValidatorPatternBuilder builder) {
        this.builder = builder;
    }

    static DataDerivType dataDerivType(ValidatorPatternBuilder builder, Pattern pattern) {
        return (DataDerivType)pattern.apply(builder.getDataDerivTypeFunction());
    }

    @Override
    public Object caseOther(Pattern p) {
        return new SingleDataDerivType();
    }

    @Override
    public Object caseAfter(AfterPattern p) {
        Pattern p1 = p.getOperand1();
        DataDerivType ddt = this.apply(p.getOperand1());
        if (!p1.isNullable()) {
            return ddt;
        }
        return ddt.combine(new BlankDataDerivType());
    }

    private Object caseBinary(BinaryPattern p) {
        return this.apply(p.getOperand1()).combine(this.apply(p.getOperand2()));
    }

    @Override
    public Object caseChoice(ChoicePattern p) {
        return this.caseBinary(p);
    }

    @Override
    public Object caseGroup(GroupPattern p) {
        return this.caseBinary(p);
    }

    @Override
    public Object caseInterleave(InterleavePattern p) {
        return this.caseBinary(p);
    }

    @Override
    public Object caseOneOrMore(OneOrMorePattern p) {
        return this.apply(p.getOperand());
    }

    @Override
    public Object caseList(ListPattern p) {
        return InconsistentDataDerivType.getInstance();
    }

    @Override
    public Object caseValue(ValuePattern p) {
        return new ValueDataDerivType(p.getDatatype());
    }

    @Override
    public Object caseData(DataPattern p) {
        if (p.allowsAnyString()) {
            return new SingleDataDerivType();
        }
        return new DataDataDerivType(p.getDatatype());
    }

    @Override
    public Object caseDataExcept(DataExceptPattern p) {
        if (p.allowsAnyString()) {
            return this.apply(p.getExcept());
        }
        return new DataDataDerivType(p.getDatatype()).combine(this.apply(p.getExcept()));
    }

    private DataDerivType apply(Pattern p) {
        return this.builder.getPatternMemo(p).dataDerivType();
    }
}

