/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.Measure;
import com.thaiopensource.xml.util.StringSplitter;
import org.relaxng.datatype.ValidationContext;

class ListDatatype
extends DatatypeBase
implements Measure {
    private final DatatypeBase itemType;

    ListDatatype(DatatypeBase itemType) {
        this.itemType = itemType;
    }

    @Override
    Object getValue(String str, ValidationContext vc) {
        String[] tokens = StringSplitter.split(str);
        Object[] items = new Object[tokens.length];
        int i = 0;
        while (i < items.length) {
            items[i] = this.itemType.getValue(tokens[i], vc);
            if (items[i] == null) {
                return null;
            }
            ++i;
        }
        return items;
    }

    @Override
    boolean lexicallyAllows(String str) {
        String[] tokens = StringSplitter.split(str);
        int i = 0;
        while (i < tokens.length) {
            if (!this.itemType.lexicallyAllows(tokens[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    boolean allowsValue(String str, ValidationContext vc) {
        String[] tokens = StringSplitter.split(str);
        int i = 0;
        while (i < tokens.length) {
            if (!this.itemType.allowsValue(tokens[i], vc)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    Measure getMeasure() {
        return this;
    }

    @Override
    public int getLength(Object obj) {
        return ((Object[])obj).length;
    }

    @Override
    public boolean isContextDependent() {
        return this.itemType.isContextDependent();
    }

    @Override
    public int getIdType() {
        if (this.itemType.getIdType() == 2) {
            return 3;
        }
        return 0;
    }

    @Override
    public int valueHashCode(Object obj) {
        Object[] items = (Object[])obj;
        int hc = 0;
        int i = 0;
        while (i < items.length) {
            hc ^= this.itemType.valueHashCode(items[i]);
            ++i;
        }
        return hc;
    }

    @Override
    public boolean sameValue(Object obj1, Object obj2) {
        Object[] items1 = (Object[])obj1;
        Object[] items2 = (Object[])obj2;
        if (items1.length != items2.length) {
            return false;
        }
        int i = 0;
        while (i < items1.length) {
            if (!this.itemType.sameValue(items1[i], items2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

