/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.OrderRelation;
import com.thaiopensource.datatype.xsd.RegexDatatype;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.relaxng.datatype.ValidationContext;

class DurationDatatype
extends RegexDatatype
implements OrderRelation {
    private static final String PATTERN = "-?P([0-9]+Y)?([0-9]+M)?([0-9]+D)?(T([0-9]+H)?([0-9]+M)?(([0-9]+(\\.[0-9]*)?|\\.[0-9]+)S)?)?";
    private static final int[] REF_YEAR_MONTHS = new int[]{1696, 9, 1697, 2, 1903, 3, 1903, 7};

    DurationDatatype() {
        super(PATTERN);
    }

    @Override
    public boolean lexicallyAllows(String str) {
        if (!super.lexicallyAllows(str)) {
            return false;
        }
        char last = str.charAt(str.length() - 1);
        return last != 'P' && last != 'T';
    }

    @Override
    Object getValue(String str, ValidationContext vc) {
        int t = str.indexOf(84);
        if (t < 0) {
            t = str.length();
        }
        String date = str.substring(0, t);
        String time = str.substring(t);
        return new Duration(str.charAt(0) == '-', DurationDatatype.getIntegerField(date, 'Y'), DurationDatatype.getIntegerField(date, 'M'), DurationDatatype.getIntegerField(date, 'D'), DurationDatatype.getIntegerField(time, 'H'), DurationDatatype.getIntegerField(time, 'M'), DurationDatatype.getDecimalField(time, 'S'));
    }

    private static BigInteger getIntegerField(String str, char code) {
        int end = str.indexOf(code);
        if (end < 0) {
            return BigInteger.valueOf(0L);
        }
        int start = end;
        while (Character.isDigit(str.charAt(start - 1))) {
            --start;
        }
        return new BigInteger(str.substring(start, end));
    }

    private static BigDecimal getDecimalField(String str, char code) {
        int end = str.indexOf(code);
        if (end < 0) {
            return BigDecimal.valueOf(0L);
        }
        int start = end;
        while (!Character.isLetter(str.charAt(start - 1))) {
            --start;
        }
        return new BigDecimal(str.substring(start, end));
    }

    @Override
    OrderRelation getOrderRelation() {
        return this;
    }

    @Override
    public boolean isLessThan(Object obj1, Object obj2) {
        Duration d1 = (Duration)obj1;
        Duration d2 = (Duration)obj2;
        BigInteger months1 = DurationDatatype.computeMonths(d1);
        BigInteger months2 = DurationDatatype.computeMonths(d2);
        BigDecimal seconds1 = DurationDatatype.computeSeconds(d1);
        BigDecimal seconds2 = DurationDatatype.computeSeconds(d2);
        switch (months1.compareTo(months2)) {
            case -1: {
                if (seconds1.compareTo(seconds2) > 0) break;
                return true;
            }
            case 0: {
                return seconds1.compareTo(seconds2) < 0;
            }
            case 1: {
                if (seconds1.compareTo(seconds2) < 0) break;
                return false;
            }
        }
        int i = 0;
        while (i < REF_YEAR_MONTHS.length) {
            BigDecimal total2;
            BigDecimal total1 = DurationDatatype.daysPlusSeconds(DurationDatatype.computeDays(months1, REF_YEAR_MONTHS[i], REF_YEAR_MONTHS[i + 1]), seconds1);
            if (total1.compareTo(total2 = DurationDatatype.daysPlusSeconds(DurationDatatype.computeDays(months2, REF_YEAR_MONTHS[i], REF_YEAR_MONTHS[i + 1]), seconds2)) >= 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    private static BigInteger computeDays(BigInteger months, int refYear, int refMonth) {
        switch (months.signum()) {
            case 0: {
                return BigInteger.valueOf(0L);
            }
            case -1: {
                return DurationDatatype.computeDays(months.negate(), refYear, refMonth).negate();
            }
        }
        BigInteger[] tem = months.divideAndRemainder(BigInteger.valueOf(4800L));
        --refMonth;
        int total = 0;
        int rem = tem[1].intValue();
        while (rem > 0) {
            total += DurationDatatype.daysInMonth(refYear, refMonth);
            if (++refMonth == 12) {
                refMonth = 0;
                ++refYear;
            }
            --rem;
        }
        return tem[0].multiply(BigInteger.valueOf(146097L)).add(BigInteger.valueOf(total));
    }

    private static int daysInMonth(int year, int month) {
        switch (month) {
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return DurationDatatype.isLeapYear(year) ? 29 : 28;
            }
        }
        return 31;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    private static BigDecimal daysPlusSeconds(BigInteger days, BigDecimal seconds) {
        return seconds.add(new BigDecimal(days.multiply(BigInteger.valueOf(86400L))));
    }

    private static BigInteger computeMonths(Duration d) {
        return d.getYears().multiply(BigInteger.valueOf(12L)).add(d.getMonths());
    }

    private static BigDecimal computeSeconds(Duration d) {
        return d.getSeconds().add(new BigDecimal(d.getDays().multiply(BigInteger.valueOf(24L)).add(d.getHours()).multiply(BigInteger.valueOf(60L)).add(d.getMinutes()).multiply(BigInteger.valueOf(60L))));
    }

    public static void main(String[] args) {
        DurationDatatype dt = new DurationDatatype();
        System.err.println(dt.isLessThan(dt.getValue(args[0], null), dt.getValue(args[1], null)));
    }

    private static class Duration {
        private final BigInteger years;
        private final BigInteger months;
        private final BigInteger days;
        private final BigInteger hours;
        private final BigInteger minutes;
        private final BigDecimal seconds;

        Duration(boolean negative, BigInteger years, BigInteger months, BigInteger days, BigInteger hours, BigInteger minutes, BigDecimal seconds) {
            if (negative) {
                this.years = years.negate();
                this.months = months.negate();
                this.days = days.negate();
                this.hours = hours.negate();
                this.minutes = minutes.negate();
                this.seconds = seconds.negate();
            } else {
                this.years = years;
                this.months = months;
                this.days = days;
                this.hours = hours;
                this.minutes = minutes;
                this.seconds = seconds;
            }
        }

        BigInteger getYears() {
            return this.years;
        }

        BigInteger getMonths() {
            return this.months;
        }

        BigInteger getDays() {
            return this.days;
        }

        BigInteger getHours() {
            return this.hours;
        }

        BigInteger getMinutes() {
            return this.minutes;
        }

        BigDecimal getSeconds() {
            return this.seconds;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Duration)) {
                return false;
            }
            Duration other = (Duration)obj;
            return this.years.equals(other.years) && this.months.equals(other.months) && this.days.equals(other.days) && this.hours.equals(other.hours) && this.minutes.equals(other.minutes) && this.seconds.compareTo(other.seconds) == 0;
        }

        public int hashCode() {
            return this.years.hashCode() ^ this.months.hashCode() ^ this.days.hashCode() ^ this.hours.hashCode() ^ this.minutes.hashCode() ^ this.seconds.hashCode();
        }
    }
}

