/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.OrderRelation;
import org.relaxng.datatype.ValidationContext;

class DoubleDatatype
extends DatatypeBase
implements OrderRelation {
    DoubleDatatype() {
    }

    @Override
    boolean lexicallyAllows(String str) {
        if (str.equals("INF") || str.equals("-INF") || str.equals("NaN")) {
            return true;
        }
        int len = str.length();
        boolean hadSign = false;
        boolean hadDecimalPoint = false;
        boolean hadDigit = false;
        boolean hadE = false;
        int i = 0;
        while (i < len) {
            switch (str.charAt(i)) {
                case '+': 
                case '-': {
                    if (hadDigit || hadDecimalPoint || hadSign) {
                        return false;
                    }
                    hadSign = true;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    hadDigit = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (hadE || !hadDigit) {
                        return false;
                    }
                    hadDigit = false;
                    hadE = true;
                    hadSign = false;
                    hadDecimalPoint = false;
                    break;
                }
                case '.': {
                    if (hadDecimalPoint || hadE) {
                        return false;
                    }
                    hadDecimalPoint = true;
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return hadDigit;
    }

    @Override
    Object getValue(String str, ValidationContext vc) {
        if (str.equals("INF")) {
            return new Double(Double.POSITIVE_INFINITY);
        }
        if (str.equals("-INF")) {
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (str.equals("NaN")) {
            return new Double(Double.NaN);
        }
        return new Double(str);
    }

    @Override
    OrderRelation getOrderRelation() {
        return this;
    }

    @Override
    public boolean isLessThan(Object obj1, Object obj2) {
        return (Double)obj1 < (Double)obj2;
    }

    @Override
    public boolean sameValue(Object value1, Object value2) {
        double d2;
        double d1 = (Double)value1;
        return d1 == (d2 = ((Double)value2).doubleValue()) || d1 != d1 && d2 != d2;
    }
}

