/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ncx;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ncx.NCXHandler;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NCXChecker
implements ContentChecker {
    ZipFile zip;
    Report report;
    String path;
    XRefChecker xrefChecker;
    static XMLValidator ncxValidator = new XMLValidator("rng/ncx.rng");
    static XMLValidator ncxSchematronValidator = new XMLValidator("sch/ncx.sch");

    public NCXChecker(ZipFile zip, Report report, String path, XRefChecker xrefChecker) {
        this.zip = zip;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
    }

    @Override
    public void runChecks() {
        ZipEntry opfEntry = this.zip.getEntry(this.path);
        if (opfEntry == null) {
            this.report.error(null, 0, "NCX file " + this.path + " is missing");
        } else {
            XMLParser ncxParser = new XMLParser(this.zip, this.path, this.report);
            ncxParser.addValidator(ncxValidator);
            NCXHandler ncxHandler = new NCXHandler(ncxParser, this.path, this.xrefChecker);
            ncxParser.addXMLHandler(ncxHandler);
            ncxParser.process();
            try {
                ncxParser = new XMLParser(this.zip, this.path, this.report);
                ncxParser.addValidator(ncxSchematronValidator);
                ncxHandler = new NCXHandler(ncxParser, this.path, this.xrefChecker);
                ncxParser.process();
            }
            catch (Throwable t) {
                this.report.error(this.path, -1, "Failed performing NCX Schematron tests: " + t.getMessage());
            }
        }
    }
}

