/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.autotest;

import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.autotest.Result;
import com.adobe.epubcheck.util.DefaultReportImpl;
import java.io.File;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class AutoTestContentHandler
implements ContentHandler {
    Report report;
    String path;
    public static final String TESTSUITE = "testsuite";
    public static final String TEST = "test";
    public static final String TYPE = "type";
    public static final String TITLE = "title";
    public static final String FILE = "file";
    public static final String DESCRIPTION = "description";
    public static final String RESULTTAG = "result";
    public static final String VALIDITY = "valid";
    public static final String ERRORS = "errors";
    public static final String WARNINGS = "warnings";
    boolean inFile = false;
    boolean inDesc = false;
    boolean inErrors = false;
    boolean inWarnings = false;
    String urlString = "";
    String zipFile = "";
    String desc = "";
    Result expectedResult;
    Result result;
    int testsRun;
    int testsPassed;

    public AutoTestContentHandler(String str) {
        this.path = str;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inFile) {
            this.zipFile = this.path;
            this.zipFile = String.valueOf(this.zipFile) + new String(ch, start, length).trim();
        } else if (this.inDesc) {
            this.desc = new String(ch, start, length).trim();
        } else if (this.inErrors) {
            int errors;
            try {
                errors = Integer.parseInt(new String(ch, start, length));
            }
            catch (NumberFormatException e) {
                errors = 0;
            }
            this.expectedResult.setErrors(errors);
        } else if (this.inWarnings) {
            int warnings;
            try {
                warnings = Integer.parseInt(new String(ch, start, length));
            }
            catch (NumberFormatException e) {
                warnings = 0;
            }
            this.expectedResult.setWarnings(warnings);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equals(TESTSUITE)) {
            System.out.println();
            System.out.println("Tests run:" + this.testsRun);
            System.out.println("Tests passed:" + this.testsPassed);
        } else if (name.equals(TEST)) {
            System.out.println();
            System.out.println(this.zipFile);
            DefaultReportImpl report = new DefaultReportImpl(this.zipFile);
            EpubCheck check = new EpubCheck(new File(this.zipFile), report);
            this.result.setValid(check.validate());
            this.result.setErrors(check.errorCount);
            this.result.setWarnings(check.warningCount);
            if (this.result.isValid() == this.expectedResult.isValid() && this.result.getErrors() == this.expectedResult.getErrors() && this.result.getWarnings() == this.expectedResult.getWarnings()) {
                ++this.testsPassed;
            } else {
                System.out.println("***********************");
                System.out.println("Test Failed");
                System.out.println("\t" + this.zipFile);
                System.out.println("\t" + this.desc);
                System.out.println("\tExpectedErrors: " + this.expectedResult.getErrors());
                System.out.println("\tExpectedWarnings: " + this.expectedResult.getWarnings());
                System.out.println("***********************");
            }
            ++this.testsRun;
        } else if (name.equals(FILE)) {
            this.inFile = false;
        } else if (name.equals(DESCRIPTION)) {
            this.inDesc = false;
        } else if (name.equals(WARNINGS)) {
            this.inWarnings = false;
        } else if (name.equals(ERRORS)) {
            this.inErrors = false;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (name.equals(TESTSUITE)) {
            this.testsRun = 0;
            this.testsPassed = 0;
        } else if (name.equals(TEST)) {
            this.expectedResult = new Result();
            this.result = new Result();
            this.zipFile = "";
            this.desc = "";
        } else if (name.equals(FILE)) {
            this.inFile = true;
        } else if (name.equals(DESCRIPTION)) {
            this.inDesc = true;
        } else if (name.equals(RESULTTAG)) {
            boolean valid = false;
            try {
                valid = atts.getValue("", VALIDITY).equals("true");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.expectedResult.setValid(valid);
        } else if (name.equals(WARNINGS)) {
            this.inWarnings = true;
        } else if (name.equals(ERRORS)) {
            this.inErrors = true;
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

