/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.util.Equal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

class ContextMap {
    private Object rootValue;
    private Object otherValue;
    private final Hashtable nameTable = new Hashtable();

    ContextMap() {
    }

    Object get(Vector context) {
        return this.get(context, context.size());
    }

    boolean put(boolean isRoot, Vector names, Object value) {
        return this.put(isRoot, names, names.size(), value);
    }

    private Object get(Vector context, int len) {
        Object value;
        ContextMap nestedMap;
        if (len > 0 && (nestedMap = (ContextMap)this.nameTable.get(context.elementAt(len - 1))) != null && (value = nestedMap.get(context, len - 1)) != null) {
            return value;
        }
        if (this.rootValue != null && len == 0) {
            return this.rootValue;
        }
        return this.otherValue;
    }

    private boolean put(boolean isRoot, Vector names, int len, Object value) {
        if (len == 0) {
            if (isRoot) {
                if (this.rootValue != null) {
                    return false;
                }
                this.rootValue = value;
            } else {
                if (this.otherValue != null) {
                    return false;
                }
                this.otherValue = value;
            }
            return true;
        }
        Object name = names.elementAt(len - 1);
        ContextMap nestedMap = (ContextMap)this.nameTable.get(name);
        if (nestedMap == null) {
            nestedMap = new ContextMap();
            this.nameTable.put(name, nestedMap);
        }
        return nestedMap.put(isRoot, names, len - 1, value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContextMap)) {
            return false;
        }
        ContextMap other = (ContextMap)obj;
        if (!Equal.equal(this.rootValue, other.rootValue) || !Equal.equal(this.otherValue, other.otherValue)) {
            return false;
        }
        if (this.nameTable.size() != other.nameTable.size()) {
            return false;
        }
        Enumeration e = this.nameTable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (this.nameTable.get(key).equals(other.nameTable.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        if (this.rootValue != null) {
            hc ^= this.rootValue.hashCode();
        }
        if (this.otherValue != null) {
            hc ^= this.otherValue.hashCode();
        }
        Enumeration e = this.nameTable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            hc ^= key.hashCode();
            hc ^= this.nameTable.get(key).hashCode();
        }
        return hc;
    }

    Enumeration values() {
        return new Enumerator(this);
    }

    private static class Enumerator
    implements Enumeration {
        private Object rootValue;
        private Object otherValue;
        private Enumeration subMapValues;
        private final Enumeration subMaps;

        private Enumerator(ContextMap map) {
            this.rootValue = map.rootValue;
            this.otherValue = map.otherValue;
            this.subMaps = map.nameTable.elements();
        }

        private void prep() {
            while ((this.subMapValues == null || !this.subMapValues.hasMoreElements()) && this.subMaps.hasMoreElements()) {
                this.subMapValues = ((ContextMap)this.subMaps.nextElement()).values();
            }
        }

        @Override
        public boolean hasMoreElements() {
            this.prep();
            return this.rootValue != null || this.otherValue != null || this.subMapValues != null && this.subMapValues.hasMoreElements();
        }

        public Object nextElement() {
            if (this.rootValue != null) {
                Object tem = this.rootValue;
                this.rootValue = null;
                return tem;
            }
            if (this.otherValue != null) {
                Object tem = this.otherValue;
                this.otherValue = null;
                return tem;
            }
            this.prep();
            if (this.subMapValues == null) {
                throw new NoSuchElementException();
            }
            return this.subMapValues.nextElement();
        }
    }
}

