/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.mns;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.mns.ContextMap;
import com.thaiopensource.validate.mns.ElementsOrAttributes;
import com.thaiopensource.validate.mns.Hashset;
import com.thaiopensource.validate.mns.NamespaceFilteredAttributes;
import com.thaiopensource.validate.mns.SchemaImpl;
import com.thaiopensource.xml.util.Name;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ValidatorImpl
extends DefaultHandler
implements Validator {
    private static final String BEARER_URI = "";
    private static final String BEARER_LOCAL_NAME = "#bearer";
    private SchemaImpl.Mode currentMode;
    private int laxDepth = 0;
    private final ErrorHandler eh;
    private final PropertyMap properties;
    private Locator locator;
    private Subtree subtrees = null;
    private final Hashset attributeNamespaces = new Hashset();
    private PrefixMapping prefixMapping = null;
    private final Localizer localizer = new Localizer(ValidatorImpl.class);
    private final Hashtable validatorCache = new Hashtable();

    ValidatorImpl(SchemaImpl.Mode mode, PropertyMap properties) {
        this.currentMode = mode;
        this.properties = properties;
        this.eh = ValidateProperty.ERROR_HANDLER.get(properties);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        Subtree st = this.subtrees;
        while (this.wantsEvent(st)) {
            st.validator.getContentHandler().characters(ch, start, length);
            st = st.parent;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        Subtree st = this.subtrees;
        while (this.wantsEvent(st)) {
            st.validator.getContentHandler().ignorableWhitespace(ch, start, length);
            st = st.parent;
        }
    }

    private SchemaImpl.Mode getMode() {
        SchemaImpl.Mode mode;
        if (this.subtrees != null && (mode = (SchemaImpl.Mode)this.subtrees.contextMap.get(this.subtrees.context)) != null) {
            return mode;
        }
        return this.currentMode;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.namespaceCovered(uri)) {
            this.subtrees.context.push(new Name(uri, localName));
        } else {
            SchemaImpl.Mode mode = this.getMode();
            SchemaImpl.ElementAction elementAction = mode.getElementAction(uri);
            if (elementAction == null) {
                if (this.laxDepth == 0 && !mode.getLax().containsElements()) {
                    this.error("element_undeclared_namespace", uri);
                }
                ++this.laxDepth;
            } else {
                this.subtrees = new Subtree(elementAction.getCoveredNamespaces(), elementAction.getContextMap(), elementAction.getPrune(), this.createValidator(elementAction.getSchema()), elementAction.getSchema(), this.currentMode, this.laxDepth, this.subtrees);
                this.subtrees.context.push(new Name(uri, localName));
                this.currentMode = elementAction.getMode();
                this.laxDepth = 0;
                this.startSubtree(this.subtrees.validator.getContentHandler());
            }
        }
        Subtree st = this.subtrees;
        while (this.wantsEvent(st)) {
            Attributes prunedAtts = st.prune.containsAttributes() ? new NamespaceFilteredAttributes(uri, true, attributes) : attributes;
            st.validator.getContentHandler().startElement(uri, localName, qName, prunedAtts);
            st = st.parent;
        }
        int i = 0;
        int len = attributes.getLength();
        while (i < len) {
            String ns = attributes.getURI(i);
            if (!(ns.equals(BEARER_URI) || ns.equals(uri) || this.namespaceCovered(ns) || this.attributeNamespaces.contains(ns))) {
                this.attributeNamespaces.add(ns);
                this.validateAttributes(ns, attributes);
            }
            ++i;
        }
        this.attributeNamespaces.clear();
    }

    private boolean namespaceCovered(String ns) {
        return this.laxDepth == 0 && this.subtrees != null && this.subtrees.coveredNamespaces.contains(ns);
    }

    private boolean wantsEvent(Subtree st) {
        return st != null && (!st.prune.containsElements() || this.laxDepth == 0 && st == this.subtrees);
    }

    private void validateAttributes(String ns, Attributes attributes) throws SAXException {
        SchemaImpl.Mode mode = this.getMode();
        Schema attributesSchema = mode.getAttributesSchema(ns);
        if (attributesSchema == null) {
            if (!mode.getLax().containsAttributes()) {
                this.error("attributes_undeclared_namespace", ns);
            }
            return;
        }
        Validator validator = this.createValidator(attributesSchema);
        ContentHandler ch = validator.getContentHandler();
        this.startSubtree(ch);
        ch.startElement(BEARER_URI, BEARER_LOCAL_NAME, BEARER_LOCAL_NAME, new NamespaceFilteredAttributes(ns, false, attributes));
        ch.endElement(BEARER_URI, BEARER_LOCAL_NAME, BEARER_LOCAL_NAME);
        this.endSubtree(ch);
        this.releaseValidator(attributesSchema, validator);
    }

    private void startSubtree(ContentHandler ch) throws SAXException {
        if (this.locator != null) {
            ch.setDocumentLocator(this.locator);
        }
        ch.startDocument();
        PrefixMapping pm = this.prefixMapping;
        while (pm != null) {
            ch.startPrefixMapping(pm.prefix, pm.uri);
            pm = pm.parent;
        }
    }

    private void endSubtree(ContentHandler ch) throws SAXException {
        PrefixMapping pm = this.prefixMapping;
        while (pm != null) {
            ch.endPrefixMapping(pm.prefix);
            pm = pm.parent;
        }
        ch.endDocument();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Subtree st = this.subtrees;
        while (this.wantsEvent(st)) {
            st.validator.getContentHandler().endElement(uri, localName, qName);
            st = st.parent;
        }
        if (this.laxDepth > 0) {
            --this.laxDepth;
        } else if (!this.subtrees.context.empty()) {
            this.subtrees.context.pop();
            if (this.subtrees.context.empty()) {
                this.endSubtree(this.subtrees.validator.getContentHandler());
                this.releaseValidator(this.subtrees.schema, this.subtrees.validator);
                this.currentMode = this.subtrees.parentMode;
                this.laxDepth = this.subtrees.parentLaxDepth;
                this.subtrees = this.subtrees.parent;
            }
        }
    }

    private Validator createValidator(Schema schema) {
        Stack stack = (Stack)this.validatorCache.get(schema);
        if (stack == null) {
            stack = new Stack();
            this.validatorCache.put(schema, stack);
        }
        if (stack.empty()) {
            return schema.createValidator(this.properties);
        }
        return (Validator)stack.pop();
    }

    private void releaseValidator(Schema schema, Validator validator) {
        validator.reset();
        ((Stack)this.validatorCache.get(schema)).push(validator);
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.prefixMapping = new PrefixMapping(prefix, uri, this.prefixMapping);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        this.prefixMapping = this.prefixMapping.parent;
    }

    @Override
    public void reset() {
        this.subtrees = null;
        this.locator = null;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    private void error(String key, String arg) throws SAXException {
        this.eh.error(new SAXParseException(this.localizer.message(key, arg), this.locator));
    }

    private static class PrefixMapping {
        final String prefix;
        final String uri;
        final PrefixMapping parent;

        PrefixMapping(String prefix, String uri, PrefixMapping parent) {
            this.prefix = prefix;
            this.uri = uri;
            this.parent = parent;
        }
    }

    private static class Subtree {
        final Subtree parent;
        final Validator validator;
        final Schema schema;
        final Hashset coveredNamespaces;
        final ElementsOrAttributes prune;
        final SchemaImpl.Mode parentMode;
        final int parentLaxDepth;
        final Stack context = new Stack();
        final ContextMap contextMap;

        Subtree(Hashset coveredNamespaces, ContextMap contextMap, ElementsOrAttributes prune, Validator validator, Schema schema, SchemaImpl.Mode parentMode, int parentLaxDepth, Subtree parent) {
            this.coveredNamespaces = coveredNamespaces;
            this.contextMap = contextMap;
            this.prune = prune;
            this.validator = validator;
            this.schema = schema;
            this.parentMode = parentMode;
            this.parentLaxDepth = parentLaxDepth;
            this.parent = parent;
        }
    }
}

