/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.mns;

import org.xml.sax.Attributes;

class NamespaceFilteredAttributes
implements Attributes {
    private final String ns;
    private final boolean keepLocal;
    private final Attributes attributes;
    private final int[] indexMap;
    private final int[] reverseIndexMap;

    public NamespaceFilteredAttributes(String ns, boolean keepLocal, Attributes attributes) {
        this.ns = ns;
        this.keepLocal = keepLocal;
        this.attributes = attributes;
        int n = 0;
        int i = 0;
        int len = attributes.getLength();
        while (i < len) {
            if (this.keepAttribute(attributes.getURI(i))) {
                ++n;
            }
            ++i;
        }
        this.indexMap = new int[n];
        this.reverseIndexMap = new int[attributes.getLength()];
        n = 0;
        i = 0;
        len = attributes.getLength();
        while (i < len) {
            if (this.keepAttribute(attributes.getURI(i))) {
                this.reverseIndexMap[i] = n;
                this.indexMap[n++] = i;
            } else {
                this.reverseIndexMap[i] = -1;
            }
            ++i;
        }
    }

    private boolean keepAttribute(String uri) {
        return uri.equals(this.ns) || this.keepLocal && uri.equals("");
    }

    @Override
    public int getLength() {
        return this.indexMap.length;
    }

    @Override
    public String getURI(int index) {
        if (index < 0 || index >= this.indexMap.length) {
            return null;
        }
        return this.attributes.getURI(this.indexMap[index]);
    }

    @Override
    public String getLocalName(int index) {
        if (index < 0 || index >= this.indexMap.length) {
            return null;
        }
        return this.attributes.getLocalName(this.indexMap[index]);
    }

    @Override
    public String getQName(int index) {
        if (index < 0 || index >= this.indexMap.length) {
            return null;
        }
        return this.attributes.getQName(this.indexMap[index]);
    }

    @Override
    public String getType(int index) {
        if (index < 0 || index >= this.indexMap.length) {
            return null;
        }
        return this.attributes.getType(this.indexMap[index]);
    }

    @Override
    public String getValue(int index) {
        if (index < 0 || index >= this.indexMap.length) {
            return null;
        }
        return this.attributes.getValue(this.indexMap[index]);
    }

    @Override
    public int getIndex(String uri, String localName) {
        int n = this.attributes.getIndex(uri, localName);
        if (n < 0) {
            return n;
        }
        return this.reverseIndexMap[n];
    }

    @Override
    public int getIndex(String qName) {
        int n = this.attributes.getIndex(qName);
        if (n < 0) {
            return n;
        }
        return this.reverseIndexMap[n];
    }

    @Override
    public String getType(String uri, String localName) {
        if (this.keepAttribute(uri)) {
            return this.attributes.getType(uri, localName);
        }
        return null;
    }

    @Override
    public String getValue(String uri, String localName) {
        if (this.keepAttribute(uri)) {
            return this.attributes.getValue(uri, localName);
        }
        return null;
    }

    @Override
    public String getType(String qName) {
        int i = this.getIndex(qName);
        if (i < 0) {
            return null;
        }
        return this.getType(i);
    }

    @Override
    public String getValue(String qName) {
        int i = this.getIndex(qName);
        if (i < 0) {
            return null;
        }
        return this.getValue(i);
    }
}

