/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.auto;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.auto.Rewindable;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import java.io.IOException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AutoSchemaReceiver
implements SchemaReceiver {
    private final PropertyMap properties;
    private final Rewindable rewindable;

    public AutoSchemaReceiver(PropertyMap properties, Rewindable rewindable) {
        this.properties = properties;
        this.rewindable = rewindable;
    }

    @Override
    public SchemaFuture installHandlers(XMLReader xr) {
        Handler h = new Handler(xr);
        xr.setContentHandler(h);
        return h;
    }

    private class Handler
    extends DefaultHandler
    implements SchemaFuture {
        private final XMLReader xr;
        private SchemaFuture sf = null;
        private Locator locator = null;
        private final Vector prefixMappings = new Vector();

        private Handler(XMLReader xr) {
            this.xr = xr;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            this.prefixMappings.addElement(prefix);
            this.prefixMappings.addElement(uri);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            SchemaReceiverFactory srf = SchemaReceiverFactory.PROPERTY.get(AutoSchemaReceiver.this.properties);
            SchemaReceiver sr = srf.createSchemaReceiver(uri, AutoSchemaReceiver.this.properties);
            if (sr == null) {
                Localizer localizer = new Localizer(AutoSchemaReceiver.class);
                String detail = "".equals(uri) ? localizer.message("no_namespace") : localizer.message("unknown_namespace", uri);
                throw new SAXParseException(detail, this.locator);
            }
            this.sf = sr.installHandlers(this.xr);
            AutoSchemaReceiver.this.rewindable.willNotRewind();
            ContentHandler contentHandler = this.xr.getContentHandler();
            if (contentHandler == null) {
                return;
            }
            if (this.locator != null) {
                contentHandler.setDocumentLocator(this.locator);
                contentHandler = this.xr.getContentHandler();
            }
            contentHandler.startDocument();
            contentHandler = this.xr.getContentHandler();
            int i = 0;
            int len = this.prefixMappings.size();
            while (i < len) {
                contentHandler.startPrefixMapping((String)this.prefixMappings.elementAt(i), (String)this.prefixMappings.elementAt(i + 1));
                contentHandler = this.xr.getContentHandler();
                i += 2;
            }
            contentHandler.startElement(uri, localName, qName, attributes);
        }

        @Override
        public Schema getSchema() throws IncorrectSchemaException, SAXException, IOException {
            if (this.sf == null) {
                throw new IncorrectSchemaException();
            }
            return this.sf.getSchema();
        }

        @Override
        public RuntimeException unwrapException(RuntimeException e) throws SAXException, IOException, IncorrectSchemaException {
            if (this.sf == null) {
                return e;
            }
            return this.sf.unwrapException(e);
        }
    }
}

