/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

public class OptionParser {
    private final String optionSpec;
    private char optionChar = '\u0000';
    private String optionArg = null;
    private int argIndex = 0;
    private int currentOptionIndex = 0;
    private final String[] args;
    private static final char OPTION_CHAR = '-';

    public OptionParser(String optionSpec, String[] args) {
        this.optionSpec = optionSpec;
        this.args = new String[args.length];
        System.arraycopy(args, 0, this.args, 0, args.length);
    }

    public char getOptionChar() {
        return this.optionChar;
    }

    public String getOptionCharString() {
        return new String(new char[]{this.optionChar});
    }

    public String getOptionArg() {
        return this.optionArg;
    }

    public boolean moveToNextOption() throws InvalidOptionException, MissingArgumentException {
        if (this.currentOptionIndex > 0 && this.currentOptionIndex == this.args[this.argIndex].length()) {
            this.currentOptionIndex = 0;
            ++this.argIndex;
        }
        if (this.currentOptionIndex == 0) {
            if (this.argIndex >= this.args.length) {
                return false;
            }
            String arg = this.args[this.argIndex];
            if (arg.length() < 2 || arg.charAt(0) != '-') {
                return false;
            }
            if (arg.length() == 2 && arg.charAt(1) == '-') {
                ++this.argIndex;
                return false;
            }
            this.currentOptionIndex = 1;
        }
        this.optionChar = this.args[this.argIndex].charAt(this.currentOptionIndex++);
        this.optionArg = null;
        int i = this.optionSpec.indexOf(this.optionChar);
        if (i < 0 || this.optionChar == ':' && i > 0) {
            throw new InvalidOptionException();
        }
        if (i + 1 < this.optionSpec.length() && this.optionSpec.charAt(i + 1) == ':') {
            if (this.currentOptionIndex < this.args[this.argIndex].length()) {
                this.optionArg = this.args[this.argIndex].substring(this.currentOptionIndex);
                this.currentOptionIndex = 0;
                ++this.argIndex;
            } else if (this.argIndex + 1 < this.args.length) {
                this.optionArg = this.args[++this.argIndex];
                ++this.argIndex;
                this.currentOptionIndex = 0;
            } else {
                throw new MissingArgumentException();
            }
        }
        return true;
    }

    public String[] getRemainingArgs() {
        String[] tem = new String[this.args.length - this.argIndex];
        System.arraycopy(this.args, this.argIndex, tem, 0, tem.length);
        return tem;
    }

    public static void main(String[] args) {
        String optSpec = args[0];
        String[] tem = new String[args.length - 1];
        System.arraycopy(args, 1, tem, 0, tem.length);
        args = tem;
        OptionParser opts = new OptionParser(optSpec, args);
        try {
            while (opts.moveToNextOption()) {
                System.err.print("option " + opts.getOptionChar());
                String arg = opts.getOptionArg();
                if (arg == null) {
                    System.err.println(" (no argument)");
                    continue;
                }
                System.err.println(" arg=" + arg);
            }
            args = opts.getRemainingArgs();
            int i = 0;
            while (i < args.length) {
                System.err.println("arg=" + args[i]);
                ++i;
            }
        }
        catch (MissingArgumentException e) {
            System.err.println("missing argument for option " + opts.getOptionChar());
        }
        catch (InvalidOptionException e) {
            System.err.println("invalid option " + opts.getOptionChar());
        }
    }

    public static class InvalidOptionException
    extends Exception {
    }

    public static class MissingArgumentException
    extends Exception {
    }
}

