/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.StringPattern;
import org.relaxng.datatype.Datatype;

class ValuePattern
extends StringPattern {
    private final Object obj;
    private final Datatype dt;

    ValuePattern(Datatype dt, Object obj) {
        super(ValuePattern.combineHashCode(27, obj.hashCode()));
        this.dt = dt;
        this.obj = obj;
    }

    @Override
    boolean samePattern(Pattern other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!(other instanceof ValuePattern)) {
            return false;
        }
        return this.dt.equals(((ValuePattern)other).dt) && this.dt.sameValue(this.obj, ((ValuePattern)other).obj);
    }

    @Override
    void accept(PatternVisitor visitor) {
        visitor.visitValue(this.dt, this.obj);
    }

    @Override
    Object apply(PatternFunction f) {
        return f.caseValue(this);
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        switch (context) {
            case 0: {
                throw new RestrictionViolationException("start_contains_value");
            }
        }
    }

    Datatype getDatatype() {
        return this.dt;
    }

    Object getValue() {
        return this.obj;
    }
}

