/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataDerivTypeFunction;
import com.thaiopensource.relaxng.impl.EndAttributesFunction;
import com.thaiopensource.relaxng.impl.EndTagDerivFunction;
import com.thaiopensource.relaxng.impl.IgnoreMissingAttributesFunction;
import com.thaiopensource.relaxng.impl.MixedTextDerivFunction;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternBuilder;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.RecoverAfterFunction;
import com.thaiopensource.relaxng.impl.TextOnlyFunction;
import java.util.Hashtable;

public class ValidatorPatternBuilder
extends PatternBuilder {
    private final Hashtable patternMemoMap = new Hashtable();
    private final PatternFunction endAttributesFunction;
    private final PatternFunction ignoreMissingAttributesFunction;
    private final PatternFunction endTagDerivFunction;
    private final PatternFunction mixedTextDerivFunction;
    private final PatternFunction textOnlyFunction;
    private final PatternFunction recoverAfterFunction;
    private final PatternFunction dataDerivTypeFunction;
    private final Hashtable choiceMap = new Hashtable();
    private final PatternFunction removeChoicesFunction = new RemoveChoicesFunction();
    private final PatternFunction noteChoicesFunction = new NoteChoicesFunction();

    public ValidatorPatternBuilder(PatternBuilder builder) {
        super(builder);
        this.endAttributesFunction = new EndAttributesFunction(this);
        this.ignoreMissingAttributesFunction = new IgnoreMissingAttributesFunction(this);
        this.endTagDerivFunction = new EndTagDerivFunction(this);
        this.mixedTextDerivFunction = new MixedTextDerivFunction(this);
        this.textOnlyFunction = new TextOnlyFunction(this);
        this.recoverAfterFunction = new RecoverAfterFunction(this);
        this.dataDerivTypeFunction = new DataDerivTypeFunction(this);
    }

    PatternMemo getPatternMemo(Pattern p) {
        PatternMemo memo = (PatternMemo)this.patternMemoMap.get(p);
        if (memo == null) {
            memo = new PatternMemo(p, this);
            this.patternMemoMap.put(p, memo);
        }
        return memo;
    }

    PatternFunction getEndAttributesFunction() {
        return this.endAttributesFunction;
    }

    PatternFunction getIgnoreMissingAttributesFunction() {
        return this.ignoreMissingAttributesFunction;
    }

    PatternFunction getEndTagDerivFunction() {
        return this.endTagDerivFunction;
    }

    PatternFunction getMixedTextDerivFunction() {
        return this.mixedTextDerivFunction;
    }

    PatternFunction getTextOnlyFunction() {
        return this.textOnlyFunction;
    }

    PatternFunction getRecoverAfterFunction() {
        return this.recoverAfterFunction;
    }

    PatternFunction getDataDerivTypeFunction() {
        return this.dataDerivTypeFunction;
    }

    Pattern makeAfter(Pattern p1, Pattern p2) {
        AfterPattern p = new AfterPattern(p1, p2);
        return this.interner.intern(p);
    }

    @Override
    Pattern makeChoice(Pattern p1, Pattern p2) {
        if (p1 == p2) {
            return p1;
        }
        if (p1 == this.notAllowed) {
            return p2;
        }
        if (p2 == this.notAllowed) {
            return p1;
        }
        if (!(p1 instanceof ChoicePattern)) {
            if (p2.containsChoice(p1)) {
                return p2;
            }
        } else if (!(p2 instanceof ChoicePattern)) {
            if (p1.containsChoice(p2)) {
                return p1;
            }
        } else {
            p1.apply(this.noteChoicesFunction);
            p2 = p2.applyForPattern(this.removeChoicesFunction);
            if (this.choiceMap.size() > 0) {
                this.choiceMap.clear();
            }
        }
        if (p1 instanceof AfterPattern && p2 instanceof AfterPattern) {
            AfterPattern ap1 = (AfterPattern)p1;
            AfterPattern ap2 = (AfterPattern)p2;
            if (ap1.getOperand1() == ap2.getOperand1()) {
                return this.makeAfter(ap1.getOperand1(), this.makeChoice(ap1.getOperand2(), ap2.getOperand2()));
            }
            if (ap1.getOperand1() == this.notAllowed) {
                return ap2;
            }
            if (ap2.getOperand1() == this.notAllowed) {
                return ap1;
            }
            if (ap1.getOperand2() == ap2.getOperand2()) {
                return this.makeAfter(this.makeChoice(ap1.getOperand1(), ap2.getOperand1()), ap1.getOperand2());
            }
        }
        return super.makeChoice(p1, p2);
    }

    private class NoteChoicesFunction
    extends AbstractPatternFunction {
        private NoteChoicesFunction() {
        }

        @Override
        public Object caseOther(Pattern p) {
            ValidatorPatternBuilder.this.choiceMap.put(p, p);
            return null;
        }

        @Override
        public Object caseChoice(ChoicePattern p) {
            p.getOperand1().apply(this);
            p.getOperand2().apply(this);
            return null;
        }
    }

    private class RemoveChoicesFunction
    extends AbstractPatternFunction {
        private RemoveChoicesFunction() {
        }

        @Override
        public Object caseOther(Pattern p) {
            if (ValidatorPatternBuilder.this.choiceMap.get(p) != null) {
                return ValidatorPatternBuilder.this.notAllowed;
            }
            return p;
        }

        @Override
        public Object caseChoice(ChoicePattern p) {
            Pattern p1 = p.getOperand1().applyForPattern(this);
            Pattern p2 = p.getOperand2().applyForPattern(this);
            if (p1 == p.getOperand1() && p2 == p.getOperand2()) {
                return p;
            }
            if (p1 == ValidatorPatternBuilder.this.notAllowed) {
                return p2;
            }
            if (p2 == ValidatorPatternBuilder.this.notAllowed) {
                return p1;
            }
            ChoicePattern p3 = new ChoicePattern(p1, p2);
            return ValidatorPatternBuilder.this.interner.intern(p3);
        }
    }
}

