/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.NameFormatter;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import com.thaiopensource.relaxng.impl.ValuePattern;
import com.thaiopensource.xml.util.Name;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.relaxng.datatype.Datatype;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IdTypeMapBuilder {
    private boolean hadError;
    private final ErrorHandler eh;
    private final PatternFunction idTypeFunction = new IdTypeFunction();
    private final IdTypeMapImpl idTypeMap = new IdTypeMapImpl();
    private final Hashtable elementProcessed = new Hashtable();
    private final Vector possibleConflicts = new Vector();

    private void notePossibleConflict(NameClass elementNameClass, NameClass attributeNameClass, Locator loc) {
        this.possibleConflicts.addElement(new PossibleConflict(elementNameClass, attributeNameClass, loc));
    }

    private void error(String key, Locator locator) {
        this.hadError = true;
        if (this.eh != null) {
            try {
                this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key), locator));
            }
            catch (SAXException e) {
                throw new WrappedSAXException(e);
            }
        }
    }

    private void error(String key, Name arg1, Name arg2, Locator locator) {
        this.hadError = true;
        if (this.eh != null) {
            try {
                this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(key, NameFormatter.format(arg1), NameFormatter.format(arg2)), locator));
            }
            catch (SAXException e) {
                throw new WrappedSAXException(e);
            }
        }
    }

    public IdTypeMapBuilder(ErrorHandler eh, Pattern pattern) throws SAXException {
        this.eh = eh;
        try {
            pattern.apply(new BuildFunction(null, null));
            Enumeration e = this.possibleConflicts.elements();
            block2: while (e.hasMoreElements()) {
                PossibleConflict pc = (PossibleConflict)e.nextElement();
                if (pc.elementNameClass instanceof SimpleNameClass && pc.attributeNameClass instanceof SimpleNameClass) {
                    Name attributeName;
                    Name elementName = ((SimpleNameClass)pc.elementNameClass).getName();
                    int idType = this.idTypeMap.getIdType(elementName, attributeName = ((SimpleNameClass)pc.attributeNameClass).getName());
                    if (idType == 0) continue;
                    this.error("id_type_conflict", elementName, attributeName, pc.locator);
                    continue;
                }
                Enumeration f = this.idTypeMap.table.keys();
                while (f.hasMoreElements()) {
                    ScopedName sn = (ScopedName)f.nextElement();
                    if (!pc.elementNameClass.contains(sn.elementName) || !pc.attributeNameClass.contains(sn.attributeName)) continue;
                    this.error("id_type_conflict", sn.elementName, sn.attributeName, pc.locator);
                    continue block2;
                }
            }
        }
        catch (WrappedSAXException e) {
            throw e.cause;
        }
    }

    public IdTypeMap getIdTypeMap() {
        if (this.hadError) {
            return null;
        }
        return this.idTypeMap;
    }

    private class BuildFunction
    extends AbstractPatternFunction {
        private final NameClass elementNameClass;
        private final Locator locator;
        private final boolean attributeIsParent;

        BuildFunction(NameClass elementNameClass, Locator locator) {
            this.elementNameClass = elementNameClass;
            this.locator = locator;
            this.attributeIsParent = false;
        }

        BuildFunction(NameClass elementNameClass, Locator locator, boolean attributeIsParent) {
            this.elementNameClass = elementNameClass;
            this.locator = locator;
            this.attributeIsParent = attributeIsParent;
        }

        private BuildFunction down() {
            if (!this.attributeIsParent) {
                return this;
            }
            return new BuildFunction(this.elementNameClass, this.locator, false);
        }

        @Override
        public Object caseChoice(ChoicePattern p) {
            BuildFunction f = this.down();
            p.getOperand1().apply(f);
            p.getOperand2().apply(f);
            return null;
        }

        @Override
        public Object caseInterleave(InterleavePattern p) {
            BuildFunction f = this.down();
            p.getOperand1().apply(f);
            p.getOperand2().apply(f);
            return null;
        }

        @Override
        public Object caseGroup(GroupPattern p) {
            BuildFunction f = this.down();
            p.getOperand1().apply(f);
            p.getOperand2().apply(f);
            return null;
        }

        @Override
        public Object caseOneOrMore(OneOrMorePattern p) {
            p.getOperand().apply(this.down());
            return null;
        }

        @Override
        public Object caseElement(ElementPattern p) {
            if (IdTypeMapBuilder.this.elementProcessed.get(p) != null) {
                return null;
            }
            IdTypeMapBuilder.this.elementProcessed.put(p, p);
            p.getContent().apply(new BuildFunction(p.getNameClass(), p.getLocator()));
            return null;
        }

        @Override
        public Object caseAttribute(AttributePattern p) {
            int idType = (Integer)p.getContent().apply(IdTypeMapBuilder.this.idTypeFunction);
            if (idType != 0) {
                NameClass attributeNameClass = p.getNameClass();
                if (!(attributeNameClass instanceof SimpleNameClass)) {
                    IdTypeMapBuilder.this.error("id_attribute_name_class", p.getLocator());
                    return null;
                }
                this.elementNameClass.accept(new ElementNameClassVisitor(((SimpleNameClass)attributeNameClass).getName(), this.locator, idType));
            } else {
                IdTypeMapBuilder.this.notePossibleConflict(this.elementNameClass, p.getNameClass(), this.locator);
            }
            p.getContent().apply(new BuildFunction(null, p.getLocator(), true));
            return null;
        }

        private void datatype(Datatype dt) {
            if (dt.getIdType() != 0 && !this.attributeIsParent) {
                IdTypeMapBuilder.this.error("id_parent", this.locator);
            }
        }

        @Override
        public Object caseData(DataPattern p) {
            this.datatype(p.getDatatype());
            return null;
        }

        @Override
        public Object caseDataExcept(DataExceptPattern p) {
            this.datatype(p.getDatatype());
            p.getExcept().apply(this.down());
            return null;
        }

        @Override
        public Object caseValue(ValuePattern p) {
            this.datatype(p.getDatatype());
            return null;
        }

        @Override
        public Object caseList(ListPattern p) {
            p.getOperand().apply(this.down());
            return null;
        }

        @Override
        public Object caseOther(Pattern p) {
            return null;
        }
    }

    private class ElementNameClassVisitor
    implements NameClassVisitor {
        private final Name attributeName;
        private final Locator locator;
        private final int idType;

        ElementNameClassVisitor(Name attributeName, Locator locator, int idType) {
            this.attributeName = attributeName;
            this.locator = locator;
            this.idType = idType;
        }

        @Override
        public void visitChoice(NameClass nc1, NameClass nc2) {
            nc1.accept(this);
            nc2.accept(this);
        }

        @Override
        public void visitName(Name elementName) {
            int tem = IdTypeMapBuilder.this.idTypeMap.getIdType(elementName, this.attributeName);
            if (tem != 0 && tem != this.idType) {
                IdTypeMapBuilder.this.error("id_type_conflict", elementName, this.attributeName, this.locator);
            }
            IdTypeMapBuilder.this.idTypeMap.add(elementName, this.attributeName, this.idType);
        }

        @Override
        public void visitNsName(String ns) {
            this.visitOther();
        }

        @Override
        public void visitNsNameExcept(String ns, NameClass nc) {
            this.visitOther();
        }

        @Override
        public void visitAnyName() {
            this.visitOther();
        }

        @Override
        public void visitAnyNameExcept(NameClass nc) {
            this.visitOther();
        }

        @Override
        public void visitNull() {
        }

        @Override
        public void visitError() {
        }

        private void visitOther() {
            IdTypeMapBuilder.this.error("id_element_name_class", this.locator);
        }
    }

    private class IdTypeFunction
    extends AbstractPatternFunction {
        private IdTypeFunction() {
        }

        @Override
        public Object caseOther(Pattern p) {
            return new Integer(0);
        }

        @Override
        public Object caseData(DataPattern p) {
            return new Integer(p.getDatatype().getIdType());
        }

        @Override
        public Object caseDataExcept(DataExceptPattern p) {
            return new Integer(p.getDatatype().getIdType());
        }

        @Override
        public Object caseValue(ValuePattern p) {
            return new Integer(p.getDatatype().getIdType());
        }
    }

    private static class IdTypeMapImpl
    implements IdTypeMap {
        private final Hashtable table = new Hashtable();

        private IdTypeMapImpl() {
        }

        @Override
        public int getIdType(Name elementName, Name attributeName) {
            Integer n = (Integer)this.table.get(new ScopedName(elementName, attributeName));
            if (n == null) {
                return 0;
            }
            return n;
        }

        private void add(Name elementName, Name attributeName, int idType) {
            this.table.put(new ScopedName(elementName, attributeName), new Integer(idType));
        }
    }

    private static class PossibleConflict {
        private final NameClass elementNameClass;
        private final NameClass attributeNameClass;
        private final Locator locator;

        private PossibleConflict(NameClass elementNameClass, NameClass attributeNameClass, Locator locator) {
            this.elementNameClass = elementNameClass;
            this.attributeNameClass = attributeNameClass;
            this.locator = locator;
        }
    }

    private static class ScopedName {
        private final Name elementName;
        private final Name attributeName;

        private ScopedName(Name elementName, Name attributeName) {
            this.elementName = elementName;
            this.attributeName = attributeName;
        }

        public int hashCode() {
            return this.elementName.hashCode() ^ this.attributeName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ScopedName)) {
                return false;
            }
            ScopedName other = (ScopedName)obj;
            return this.elementName.equals(other.elementName) && this.attributeName.equals(other.attributeName);
        }
    }

    private static class WrappedSAXException
    extends RuntimeException {
        private final SAXException cause;

        WrappedSAXException(SAXException cause) {
            this.cause = cause;
        }
    }
}

