/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.TextPattern;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.relaxng.impl.ValuePattern;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

class DataDerivFunction
extends AbstractPatternFunction {
    private final ValidatorPatternBuilder builder;
    private final ValidationContext vc;
    private final String str;

    DataDerivFunction(String str, ValidationContext vc, ValidatorPatternBuilder builder) {
        this.str = str;
        this.vc = vc;
        this.builder = builder;
    }

    static boolean isBlank(String str) {
        int len = str.length();
        int i = 0;
        while (i < len) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public Object caseText(TextPattern p) {
        return p;
    }

    @Override
    public Object caseList(ListPattern p) {
        int len = this.str.length();
        int tokenStart = -1;
        PatternMemo memo = this.builder.getPatternMemo(p.getOperand());
        int i = 0;
        while (i < len) {
            switch (this.str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (tokenStart < 0) break;
                    memo = this.tokenDeriv(memo, tokenStart, i);
                    tokenStart = -1;
                    break;
                }
                default: {
                    if (tokenStart >= 0) break;
                    tokenStart = i;
                }
            }
            ++i;
        }
        if (tokenStart >= 0) {
            memo = this.tokenDeriv(memo, tokenStart, len);
        }
        if (memo.getPattern().isNullable()) {
            return this.builder.makeEmpty();
        }
        return this.builder.makeNotAllowed();
    }

    private PatternMemo tokenDeriv(PatternMemo p, int i, int j) {
        return p.dataDeriv(this.str.substring(i, j), this.vc);
    }

    @Override
    public Object caseValue(ValuePattern p) {
        Datatype dt = p.getDatatype();
        Object value = dt.createValue(this.str, this.vc);
        if (value != null && dt.sameValue(p.getValue(), value)) {
            return this.builder.makeEmpty();
        }
        return this.builder.makeNotAllowed();
    }

    @Override
    public Object caseData(DataPattern p) {
        if (p.allowsAnyString()) {
            return this.builder.makeEmpty();
        }
        if (p.getDatatype().isValid(this.str, this.vc)) {
            return this.builder.makeEmpty();
        }
        return this.builder.makeNotAllowed();
    }

    @Override
    public Object caseDataExcept(DataExceptPattern p) {
        Pattern tem = (Pattern)this.caseData(p);
        if (tem.isNullable() && this.memoApply(p.getExcept()).isNullable()) {
            return this.builder.makeNotAllowed();
        }
        return tem;
    }

    @Override
    public Object caseAfter(AfterPattern p) {
        Pattern p1 = p.getOperand1();
        if (this.memoApply(p1).isNullable() || p1.isNullable() && DataDerivFunction.isBlank(this.str)) {
            return p.getOperand2();
        }
        return this.builder.makeNotAllowed();
    }

    @Override
    public Object caseChoice(ChoicePattern p) {
        return this.builder.makeChoice(this.memoApply(p.getOperand1()), this.memoApply(p.getOperand2()));
    }

    @Override
    public Object caseGroup(GroupPattern p) {
        Pattern p1 = p.getOperand1();
        Pattern p2 = p.getOperand2();
        Pattern tem = this.builder.makeGroup(this.memoApply(p1), p2);
        if (!p1.isNullable()) {
            return tem;
        }
        return this.builder.makeChoice(tem, this.memoApply(p2));
    }

    @Override
    public Object caseInterleave(InterleavePattern p) {
        Pattern p1 = p.getOperand1();
        Pattern p2 = p.getOperand2();
        return this.builder.makeChoice(this.builder.makeInterleave(this.memoApply(p1), p2), this.builder.makeInterleave(p1, this.memoApply(p2)));
    }

    @Override
    public Object caseOneOrMore(OneOrMorePattern p) {
        return this.builder.makeGroup(this.memoApply(p.getOperand()), this.builder.makeOptional(p));
    }

    @Override
    public Object caseOther(Pattern p) {
        return this.builder.makeNotAllowed();
    }

    private Pattern memoApply(Pattern p) {
        return this.builder.getPatternMemo(p).dataDeriv(this.str, this.vc).getPattern();
    }
}

