/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.BuiltinDatatypeLibrary;
import com.thaiopensource.relaxng.impl.CompatibilityDatatypeLibrary;
import java.util.Hashtable;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;

class BuiltinDatatypeLibraryFactory
implements DatatypeLibraryFactory {
    private final Hashtable cache = new Hashtable();
    private final DatatypeLibraryFactory factory;
    private final DatatypeLibrary builtinDatatypeLibrary = new BuiltinDatatypeLibrary();
    private DatatypeLibrary lastDatatypeLibrary = null;
    private String lastDatatypeLibraryUri = null;

    BuiltinDatatypeLibraryFactory(DatatypeLibraryFactory factory) {
        this.factory = factory;
        this.cache.put("http://relaxng.org/ns/compatibility/datatypes/1.0", new CompatibilityDatatypeLibrary(this));
    }

    @Override
    public DatatypeLibrary createDatatypeLibrary(String uri) {
        if (uri.equals("")) {
            return this.builtinDatatypeLibrary;
        }
        if (uri.equals(this.lastDatatypeLibraryUri)) {
            return this.lastDatatypeLibrary;
        }
        DatatypeLibrary library = (DatatypeLibrary)this.cache.get(uri);
        if (library == null) {
            if (this.factory == null) {
                return null;
            }
            library = this.factory.createDatatypeLibrary(uri);
            if (library == null) {
                return null;
            }
            this.cache.put(uri, library);
        }
        this.lastDatatypeLibraryUri = uri;
        this.lastDatatypeLibrary = library;
        return this.lastDatatypeLibrary;
    }
}

