/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class AttributePattern
extends Pattern {
    private final NameClass nameClass;
    private final Pattern p;
    private final Locator loc;

    AttributePattern(NameClass nameClass, Pattern value, Locator loc) {
        super(false, 0, AttributePattern.combineHashCode(29, nameClass.hashCode(), value.hashCode()));
        this.nameClass = nameClass;
        this.p = value;
        this.loc = loc;
    }

    @Override
    Pattern expand(SchemaPatternBuilder b) {
        Pattern ep = this.p.expand(b);
        if (ep != this.p) {
            return b.makeAttribute(this.nameClass, ep, this.loc);
        }
        return this;
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        switch (context) {
            case 0: {
                throw new RestrictionViolationException("start_contains_attribute");
            }
            case 1: {
                if (!this.nameClass.isOpen()) break;
                throw new RestrictionViolationException("open_name_class_not_repeated");
            }
            case 3: {
                throw new RestrictionViolationException("one_or_more_contains_group_contains_attribute");
            }
            case 4: {
                throw new RestrictionViolationException("one_or_more_contains_interleave_contains_attribute");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_attribute");
            }
            case 5: {
                throw new RestrictionViolationException("attribute_contains_attribute");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_attribute");
            }
        }
        if (!dad.addAttribute(this.nameClass)) {
            if (this.nameClass instanceof SimpleNameClass) {
                throw new RestrictionViolationException("duplicate_attribute_detail", ((SimpleNameClass)this.nameClass).getName());
            }
            throw new RestrictionViolationException("duplicate_attribute");
        }
        try {
            this.p.checkRestrictions(5, null, null);
        }
        catch (RestrictionViolationException e) {
            e.maybeSetLocator(this.loc);
            throw e;
        }
    }

    @Override
    boolean samePattern(Pattern other) {
        if (!(other instanceof AttributePattern)) {
            return false;
        }
        AttributePattern ap = (AttributePattern)other;
        return this.nameClass.equals(ap.nameClass) && this.p == ap.p;
    }

    @Override
    void checkRecursion(int depth) throws SAXException {
        this.p.checkRecursion(depth);
    }

    @Override
    void accept(PatternVisitor visitor) {
        visitor.visitAttribute(this.nameClass, this.p);
    }

    @Override
    Object apply(PatternFunction f) {
        return f.caseAttribute(this);
    }

    Pattern getContent() {
        return this.p;
    }

    NameClass getNameClass() {
        return this.nameClass;
    }

    Locator getLocator() {
        return this.loc;
    }
}

