/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.xml.util.Naming;
import org.relaxng.datatype.ValidationContext;

class QNameDatatype
extends DatatypeBase {
    QNameDatatype() {
    }

    @Override
    public boolean lexicallyAllows(String str) {
        return Naming.isQname(str);
    }

    @Override
    Object getValue(String str, ValidationContext vc) {
        int i = str.indexOf(58);
        if (i < 0) {
            String ns = vc.resolveNamespacePrefix("");
            if (ns == null) {
                ns = "";
            }
            return new QName(ns, str);
        }
        String prefix = str.substring(0, i);
        String ns = vc.resolveNamespacePrefix(prefix);
        if (ns == null) {
            return null;
        }
        return new QName(ns, str.substring(i + 1));
    }

    @Override
    boolean allowsValue(String str, ValidationContext vc) {
        int i = str.indexOf(58);
        return i < 0 || vc.resolveNamespacePrefix(str.substring(0, i)) != null;
    }

    @Override
    public boolean isContextDependent() {
        return true;
    }

    static class QName {
        private final String namespaceURI;
        private final String localName;

        QName(String namespaceURI, String localName) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof QName)) {
                return false;
            }
            QName other = (QName)obj;
            return this.namespaceURI.equals(other.namespaceURI) && this.localName.equals(other.localName);
        }

        public int hashCode() {
            return this.localName.hashCode() ^ this.namespaceURI.hashCode();
        }
    }
}

