/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.AnyUriDatatype;
import com.thaiopensource.datatype.xsd.Base64BinaryDatatype;
import com.thaiopensource.datatype.xsd.BooleanDatatype;
import com.thaiopensource.datatype.xsd.CdataDatatype;
import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.DatatypeBuilderImpl;
import com.thaiopensource.datatype.xsd.DateTimeDatatype;
import com.thaiopensource.datatype.xsd.DecimalDatatype;
import com.thaiopensource.datatype.xsd.DoubleDatatype;
import com.thaiopensource.datatype.xsd.DurationDatatype;
import com.thaiopensource.datatype.xsd.EntityDatatype;
import com.thaiopensource.datatype.xsd.FloatDatatype;
import com.thaiopensource.datatype.xsd.HexBinaryDatatype;
import com.thaiopensource.datatype.xsd.IdDatatype;
import com.thaiopensource.datatype.xsd.IdrefDatatype;
import com.thaiopensource.datatype.xsd.IntegerRestrictDatatype;
import com.thaiopensource.datatype.xsd.ListDatatype;
import com.thaiopensource.datatype.xsd.MaxInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinLengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.NCNameDatatype;
import com.thaiopensource.datatype.xsd.NameDatatype;
import com.thaiopensource.datatype.xsd.NmtokenDatatype;
import com.thaiopensource.datatype.xsd.QNameDatatype;
import com.thaiopensource.datatype.xsd.RegexDatatype;
import com.thaiopensource.datatype.xsd.StringDatatype;
import com.thaiopensource.datatype.xsd.TokenDatatype;
import com.thaiopensource.datatype.xsd.regex.RegexEngine;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.util.Service;
import java.util.Enumeration;
import java.util.Hashtable;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;

public class DatatypeLibraryImpl
implements DatatypeLibrary {
    private final Hashtable typeTable = new Hashtable();
    private final RegexEngine regexEngine = DatatypeLibraryImpl.findRegexEngine();
    private static final String LONG_MAX = "9223372036854775807";
    private static final String LONG_MIN = "-9223372036854775808";
    private static final String INT_MAX = "2147483647";
    private static final String INT_MIN = "-2147483648";
    private static final String SHORT_MAX = "32767";
    private static final String SHORT_MIN = "-32768";
    private static final String BYTE_MAX = "127";
    private static final String BYTE_MIN = "-128";
    private static final String UNSIGNED_LONG_MAX = "18446744073709551615";
    private static final String UNSIGNED_INT_MAX = "4294967295";
    private static final String UNSIGNED_SHORT_MAX = "65535";
    private static final String UNSIGNED_BYTE_MAX = "255";
    private static final String LANGUAGE_PATTERN = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";

    public DatatypeLibraryImpl() {
        this.typeTable.put("string", new StringDatatype());
        this.typeTable.put("normalizedString", new CdataDatatype());
        this.typeTable.put("token", new TokenDatatype());
        this.typeTable.put("boolean", new BooleanDatatype());
        DecimalDatatype decimalType = new DecimalDatatype();
        this.typeTable.put("decimal", decimalType);
        IntegerRestrictDatatype integerType = new IntegerRestrictDatatype(decimalType);
        this.typeTable.put("integer", integerType);
        this.typeTable.put("nonPositiveInteger", DatatypeLibraryImpl.restrictMax(integerType, "0"));
        this.typeTable.put("negativeInteger", DatatypeLibraryImpl.restrictMax(integerType, "-1"));
        this.typeTable.put("long", DatatypeLibraryImpl.restrictMax(DatatypeLibraryImpl.restrictMin(integerType, LONG_MIN), LONG_MAX));
        this.typeTable.put("int", DatatypeLibraryImpl.restrictMax(DatatypeLibraryImpl.restrictMin(integerType, INT_MIN), INT_MAX));
        this.typeTable.put("short", DatatypeLibraryImpl.restrictMax(DatatypeLibraryImpl.restrictMin(integerType, SHORT_MIN), SHORT_MAX));
        this.typeTable.put("byte", DatatypeLibraryImpl.restrictMax(DatatypeLibraryImpl.restrictMin(integerType, BYTE_MIN), BYTE_MAX));
        DatatypeBase nonNegativeIntegerType = DatatypeLibraryImpl.restrictMin(integerType, "0");
        this.typeTable.put("nonNegativeInteger", nonNegativeIntegerType);
        this.typeTable.put("unsignedLong", DatatypeLibraryImpl.restrictMax(nonNegativeIntegerType, UNSIGNED_LONG_MAX));
        this.typeTable.put("unsignedInt", DatatypeLibraryImpl.restrictMax(nonNegativeIntegerType, UNSIGNED_INT_MAX));
        this.typeTable.put("unsignedShort", DatatypeLibraryImpl.restrictMax(nonNegativeIntegerType, UNSIGNED_SHORT_MAX));
        this.typeTable.put("unsignedByte", DatatypeLibraryImpl.restrictMax(nonNegativeIntegerType, UNSIGNED_BYTE_MAX));
        this.typeTable.put("positiveInteger", DatatypeLibraryImpl.restrictMin(integerType, "1"));
        this.typeTable.put("double", new DoubleDatatype());
        this.typeTable.put("float", new FloatDatatype());
        this.typeTable.put("Name", new NameDatatype());
        this.typeTable.put("QName", new QNameDatatype());
        NCNameDatatype ncNameType = new NCNameDatatype();
        this.typeTable.put("NCName", ncNameType);
        NmtokenDatatype nmtokenDatatype = new NmtokenDatatype();
        this.typeTable.put("NMTOKEN", nmtokenDatatype);
        this.typeTable.put("NMTOKENS", DatatypeLibraryImpl.list(nmtokenDatatype));
        this.typeTable.put("ID", new IdDatatype());
        IdrefDatatype idrefType = new IdrefDatatype();
        this.typeTable.put("IDREF", idrefType);
        this.typeTable.put("IDREFS", DatatypeLibraryImpl.list(idrefType));
        this.typeTable.put("NOTATION", new QNameDatatype());
        this.typeTable.put("base64Binary", new Base64BinaryDatatype());
        this.typeTable.put("hexBinary", new HexBinaryDatatype());
        this.typeTable.put("anyURI", new AnyUriDatatype());
        this.typeTable.put("language", new RegexDatatype(LANGUAGE_PATTERN));
        this.typeTable.put("dateTime", new DateTimeDatatype("Y-M-DTt"));
        this.typeTable.put("time", new DateTimeDatatype("t"));
        this.typeTable.put("date", new DateTimeDatatype("Y-M-D"));
        this.typeTable.put("gYearMonth", new DateTimeDatatype("Y-M"));
        this.typeTable.put("gYear", new DateTimeDatatype("Y"));
        this.typeTable.put("gMonthDay", new DateTimeDatatype("--M-D"));
        this.typeTable.put("gDay", new DateTimeDatatype("---D"));
        this.typeTable.put("gMonth", new DateTimeDatatype("--M"));
        EntityDatatype entityType = new EntityDatatype();
        this.typeTable.put("ENTITY", entityType);
        this.typeTable.put("ENTITIES", DatatypeLibraryImpl.list(entityType));
        this.typeTable.put("duration", new DurationDatatype());
    }

    @Override
    public DatatypeBuilder createDatatypeBuilder(String localName) throws DatatypeException {
        DatatypeBase base = (DatatypeBase)this.typeTable.get(localName);
        if (base == null) {
            throw new DatatypeException();
        }
        if (base instanceof RegexDatatype) {
            try {
                ((RegexDatatype)base).compile(this.getRegexEngine());
            }
            catch (RegexSyntaxException e) {
                throw new DatatypeException(DatatypeBuilderImpl.localizer.message("regex_internal_error", localName));
            }
        }
        return new DatatypeBuilderImpl(this, base);
    }

    RegexEngine getRegexEngine() throws DatatypeException {
        if (this.regexEngine == null) {
            throw new DatatypeException(DatatypeBuilderImpl.localizer.message("regex_impl_not_found"));
        }
        return this.regexEngine;
    }

    private static DatatypeBase restrictMax(DatatypeBase base, String limit) {
        return new MaxInclusiveRestrictDatatype(base, base.getValue(limit, null));
    }

    private static DatatypeBase restrictMin(DatatypeBase base, String limit) {
        return new MinInclusiveRestrictDatatype(base, base.getValue(limit, null));
    }

    private static DatatypeBase list(DatatypeBase base) {
        return new MinLengthRestrictDatatype(new ListDatatype(base), 1);
    }

    private static RegexEngine findRegexEngine() {
        Enumeration e = new Service(RegexEngine.class).getProviders();
        if (!e.hasMoreElements()) {
            return null;
        }
        return (RegexEngine)e.nextElement();
    }

    @Override
    public Datatype createDatatype(String type) throws DatatypeException {
        return this.createDatatypeBuilder(type).createDatatype();
    }

    public static void main(String[] args) throws DatatypeException {
        System.err.println(new DatatypeLibraryImpl().createDatatype(args[0]).isValid(args[1], null) ? "valid" : "invalid");
    }
}

