/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFHandler;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OCFChecker {
    ZipFile zip;
    Report report;
    HashSet encryptedItemsSet;
    static XMLValidator containerValidator = new XMLValidator("rng/container.rng");
    static XMLValidator encryptionValidator = new XMLValidator("rng/encryption.rng");
    static XMLValidator signatureValidator = new XMLValidator("rng/signatures.rng");

    public OCFChecker(ZipFile zip, Report report) {
        this.zip = zip;
        this.report = report;
    }

    public void runChecks() {
        String signatureEntry;
        ZipEntry signatures;
        String containerEntry = "META-INF/container.xml";
        ZipEntry container = this.zip.getEntry("META-INF/container.xml");
        if (container == null) {
            this.report.error(null, 0, "META-INF/container.xml is missing");
            return;
        }
        XMLParser containerParser = new XMLParser(this.zip, containerEntry, this.report);
        OCFHandler containerHandler = new OCFHandler(containerParser);
        containerParser.addXMLHandler(containerHandler);
        containerParser.addValidator(containerValidator);
        containerParser.process();
        String rootPath = containerHandler.getRootPath();
        String encryptionEntry = "META-INF/encryption.xml";
        ZipEntry encryption = this.zip.getEntry(encryptionEntry);
        if (encryption != null) {
            XMLParser encryptionParser = new XMLParser(this.zip, encryptionEntry, this.report);
            OCFHandler encryptionHandler = new OCFHandler(encryptionParser);
            encryptionHandler.setPopulateEnryptedItems(true);
            encryptionHandler.setRootBase(this.processRootPath(rootPath));
            encryptionParser.addXMLHandler(encryptionHandler);
            encryptionParser.addValidator(encryptionValidator);
            encryptionParser.process();
            this.encryptedItemsSet = encryptionHandler.getEncryptedItems();
        }
        if ((signatures = this.zip.getEntry(signatureEntry = "META-INF/signatures.xml")) != null) {
            XMLParser signatureParser = new XMLParser(this.zip, signatureEntry, this.report);
            OCFHandler signatureHandler = new OCFHandler(signatureParser);
            signatureParser.addXMLHandler(signatureHandler);
            signatureParser.addValidator(signatureValidator);
            signatureParser.process();
        }
        OPFChecker opfChecker = new OPFChecker(this.zip, this.report, rootPath);
        opfChecker.setEncryptedItemsSet(this.encryptedItemsSet);
        opfChecker.runChecks();
    }

    public String processRootPath(String rootPath) {
        String rootBase = rootPath;
        if (rootPath.endsWith(".opf")) {
            int slash = rootPath.lastIndexOf("/");
            if (slash < rootPath.lastIndexOf("\\")) {
                slash = rootPath.lastIndexOf("\\");
            }
            rootBase = slash >= 0 && slash + 1 < rootPath.length() ? rootPath.substring(0, slash + 1) : rootPath;
            return rootBase;
        }
        System.out.println("RootPath is not an OPF file");
        return null;
    }
}

