#!/bin/sh

# vim: ts=8

TMP=/tmp
TMP_SD=/mnt/tmp
SD_DIR=/mnt/firmware

USB_Y_DIR=$TMP/usby
USB_Y_SRC=$USB_Y_DIR/disk
USB_V_DIR=$TMP/usbv
USB_SRC=/dev/mtdblock6
LOOP0=/dev/loop0

MTDBLOCK7=/dev/mtdblock7
MTD7=$TMP/mtd7
PIC_DIR=$MTD7/pics

SD_PIC=/mnt/Data/mtd7/pics

ROOT_TMP=$TMP/rootfs
ROOT_DEST=/dev/mtdblock4
ROOT_DEST_TMP=/dev/mtd4
ROOT_TMP_PIC=$ROOT_TMP/data/pics

FLAG_PATH='';
SRC_PATH='';
SRC_FILE=ebook
JB_SRC_FILE=AluratekBook
M_SRC_FILE=M218C+
PASSWD=/etc/.passwd

Error_Firmware()
{
	FAIL_PIC=fail_sd.bin
	if [ -e $USB_V_DIR/M218A*.bin -o -e $SD_DIR/M218A*.bin ] ; then
		FAIL_PIC=fail_m218a.bin
	fi
	umount $USB_V_DIR && rm -rf $USB_V_DIR
	losetup -d $LOOP0
	umount $USB_Y_DIR && rm -rf $USB_Y_DIR
	mkdir $MTD7
	mount -t yaffs2 $MTDBLOCK7 $MTD7
	if [ -e $PIC_DIR/$FAIL_PIC ] ; then
		cp $PIC_DIR/$FAIL_PIC /dev/fb0
	elif [ -e $SD_PIC/$FAIL_PIC ] ; then
		cp $SD_PIC/$FAIL_PIC /dev/fb0
	elif [ -e $ROOT_TMP_PIC/$FAIL_PIC.gz ] ; then
		cp $ROOT_TMP_PIC/$FAIL_PIC.gz $TMP
		gunzip $TMP/$FAIL_PIC.gz
		cp $TMP/$FAIL_PIC /dev/fb0
	fi
	umount $MTD7
	rm -rf $MTD7
	cd $TMP && umount $ROOT_TMP && rm -rf $ROOT_TMP
	echo "No update firmware found!" && exit
}

Error_Old_Firmware()
{
	FAIL_PIC_WL=fail_ver.bin
	echo "** firmware version < 31 , don't update**"
	umount $USB_V_DIR && rm -rf $USB_V_DIR
	losetup -d $LOOP0
	umount $USB_Y_DIR && rm -rf $USB_Y_DIR
	mkdir $MTD7
	mount -t yaffs2 $MTDBLOCK7 $MTD7
	if [ -e $PIC_DIR/$FAIL_PIC_WL ] ; then
		cp $PIC_DIR/$FAIL_PIC_WL /dev/fb0
	elif [ -e $SD_PIC/$FAIL_PIC_WL ] ; then
		cp $SD_PIC/$FAIL_PIC_WL /dev/fb0
	elif [ -e $ROOT_TMP_PIC/$FAIL_PIC_WL.gz ] ; then
		cp $ROOT_TMP_PIC/$FAIL_PIC_WL.gz $TMP
		gunzip $TMP/$FAIL_PIC_WL.gz
		cp $TMP/$FAIL_PIC_WL /dev/fb0
	fi
	umount $MTD7
	rm -rf $MTD7
	cd $TMP && umount $ROOT_TMP && rm -rf $ROOT_TMP
	echo "Version is error!"
	exit
}

mkdir -p $ROOT_TMP && mount -t yaffs2 $ROOT_DEST $ROOT_TMP
mkdir $USB_Y_DIR && mount -t yaffs2 $USB_SRC $USB_Y_DIR
losetup -o 4096 $LOOP0 $USB_Y_SRC
mkdir $USB_V_DIR && mount -t vfat $LOOP0 $USB_V_DIR

if  [ -e $SD_DIR/$SRC_FILE-*.bin ] ; then
	SRC_PATH=$SD_DIR/$SRC_FILE-*.bin
	test `ls $SD_DIR/$SRC_FILE-*.bin | cut -d 'v' -f2 | cut -d '.' -f1` -gt 0 && \
	mkdir -p $TMP_SD || \
	test `ls $SD_DIR/$SRC_FILE-*.bin | cut -d '.' -f2 | cut -c 1-2` -gt 64 && \
		mkdir -p $TMP_SD || \
		TMP_SD=$TMP 
		FLAG_PATH=1
elif [ -e $SD_DIR/$JB_SRC_FILE-*.bin ] ; then
	SRC_PATH=$SD_DIR/$JB_SRC_FILE-*.bin
	test `ls $SD_DIR/$JB_SRC_FILE-*.bin | cut -d 'v' -f2 | cut -d '.' -f1` -gt 0 && \
	mkdir -p $TMP_SD || \
	test `ls $SD_DIR/$JB_SRC_FILE-*.bin | cut -d '.' -f2 | cut -c 1-2` -gt 64 && \
		mkdir -p $TMP_SD || \
		TMP_SD=$TMP || \
		FLAG_PATH=2
else
	Error_Firmware
fi

mkdir $MTD7
mount -t yaffs2 $MTDBLOCK7 $MTD7
if [ -e /mnt/tmp ] ; then 
	echo "Firmware will be decrypted to SD card"
	if [ -e $PIC_DIR/fail_sd_exceedlimit.bin ] ; then
		cp $PIC_DIR/fail_sd_exceedlimit.bin $TMP
	elif [ -e $SD_PIC/fail_sd_exceedlimit.bin ] ; then
		cp $SD_PIC/fail_sd_exceedlimit.bin $TMP
	elif [ -e $ROOT_TMP_PIC/fail_sd_exceedlimit.bin.gz ] ; then
		cp $ROOT_TMP_PIC/fail_sd_exceedlimit.bin.gz $TMP
		gunzip $TMP/fail_sd_exceedlimit.bin.gz
	fi
else
	echo "Firmware will be decrypted to /tmp"
fi

if [ -e $PIC_DIR/fail_exit.bin ] ; then
	cp $PIC_DIR/fail_exit.bin $TMP
elif [ -e $SD_PIC/fail_exit.bin ] ; then
	cp $SD_PIC/fail_exit.bin $TMP
elif [ -e $ROOT_TMP_PIC/fail_exit.bin.gz ] ; then
	cp $ROOT_TMP_PIC/fail_exit.bin.gz $TMP
	gunzip $TMP/fail_exit.bin.gz
fi
if [ -e $PIC_DIR/fail.bin ] ; then
	cp $PIC_DIR/fail.bin $TMP
elif [ -e $SD_PIC/fail.bin ] ; then
	cp $SD_PIC/fail.bin $TMP
elif [ -e $ROOT_TMP_PIC/fail.bin.gz ] ; then
	cp $ROOT_TMP_PIC/fail.bin.gz $TMP
	gunzip $TMP/fail.bin.gz
fi
if [ -e $PIC_DIR/confirm.bin ] ; then
	cp $PIC_DIR/confirm.bin $TMP
elif [ -e $SD_PIC/confirm.bin ] ; then
	cp $SD_PIC/confirm.bin $TMP
elif [ -e $ROOT_TMP_PIC/confirm.bin.gz ] ; then
	cp $ROOT_TMP_PIC/confirm.bin.gz $TMP
	gunzip $TMP/confirm.bin.gz
else
	cp $TMP/fail.bin /dev/fb0
	umount $MTD7
	rm -rf $MTD7
	cd $TMP && umount $ROOT_TMP && rm -rf $ROOT_TMP
	echo "No confirm screen found!" && exit
fi
umount $MTD7
rm -rf $MTD7
cd $TMP && umount $ROOT_TMP && rm -rf $ROOT_TMP

cp $TMP/confirm.bin /dev/fb0
/bin/p_confirm

rm -rf $TMP/fail_exit.bin
echo "Decrypting firmware!" 
#echo "Decrypting firmware!" > /dev/tty0 
/sbin/flashing.sh& 

cd $TMP_SD && aespipe -p3 -d 3< $PASSWD < `ls $SRC_PATH` | tar x -
#cd $TMP && aespipe -p3 -d 3< $PASSWD < `ls $SRC_PATH/$SRC_FILE-*.bin` | tar x -
echo "Decrypting firmware done!"

if [ -e $TMP_SD/data/JL09 ] ; then
	echo "Is JL09"
else
	echo "Is not JL09"
	killall -9 flashing.sh
	Error_Firmware
fi

umount $USB_V_DIR && rm -rf $USB_V_DIR
umount $USB_Y_DIR && rm -rf $USB_Y_DIR

if [ -e $TMP_SD/bin/run.sh ] ; then
	$TMP_SD/bin/run.sh
else
	killall -9 flashing.sh
	cp $TMP/fail.bin /dev/fb0
fi

rm -rf $TMP/*

exit
