from calibre.web.feeds.news import BasicNewsRecipe

class PolitikenEnglishRecipe(BasicNewsRecipe):
    __license__  = 'GPL v3'
    __author__ = 'kwetal'
    language = 'en_DK'
    version = 1
    
    title          = u'Politiken - English'
    publisher = u'Dagbladet Politiken'
    category = u'News'
    description = u'News from Danmark in English'
    
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content = False

    no_stylesheets = True
    
    extra_css = '''
                    body{font-family:verdana,arial,helvetica,geneva,sans-serif ;}
                    h1{font-size: xx-large;}
                    h2{font-size: large;}
                    '''
                    
    feeds = [(u'News in English', u'http://politiken.dk/rss/newsinenglish.rss')]
    
    keep_only_tags = []
    keep_only_tags.append (dict(name = 'h1'))
    keep_only_tags.append (dict(name = 'h2'))
    keep_only_tags.append (dict(name = 'div', attrs = {'class': 'main'}))
    
    def print_version(self, url):
        if '/newsinenglish/' not in url:
            return None
        
        return url + '?service=print'
