#ifndef SETTINGS_UTILS_H
#define SETTINGS_UTILS_H

/*
 * File Name: settings_utils.h
 */

/*
 * This file is part of settings.
 *
 * settings is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * settings is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */
 
#include <gtk/gtk.h>

#define SETTINGS_GCONF_PATH         "/apps/er/sys/"
#define GCONF_CURRENT_LOCALE        SETTINGS_GCONF_PATH "global/locale"
#define GCONF_LOCALE_LIST           SETTINGS_GCONF_PATH "global/list_locales"
#define GCONF_LANGUAGE_LIST         SETTINGS_GCONF_PATH "global/list_languages"
#define GCONF_ROTATION_DIRECTION    SETTINGS_GCONF_PATH "display/rotation"
#define GCONF_USE_LIGHT             SETTINGS_GCONF_PATH "sensor/use_light"
#define GCONF_USE_SOUND             SETTINGS_GCONF_PATH "sensor/use_sound"
#define GCONF_LOCK_LEFT_SENSOR      SETTINGS_GCONF_PATH "sensor/use_lock_left"
#define GCONF_LOCK_MIDDLE_SENSOR    SETTINGS_GCONF_PATH "sensor/use_lock_middle"
#define GCONF_LOCK_RIGHT_SENSOR     SETTINGS_GCONF_PATH "sensor/use_lock_right"
#define GCONF_USE_STYLUS            SETTINGS_GCONF_PATH "power/use_stylus"
#define GCONF_SEC_SUSPEND           SETTINGS_GCONF_PATH "power/sec_suspend"
#define GCONF_MIN_HIBERNATE         SETTINGS_GCONF_PATH "power/min_hibernate"
#define GCONF_HIBERNATE_IF_PLUGGED  SETTINGS_GCONF_PATH "power/hibernate_if_plugged"
#define GCONF_RECENTFILES_MODE      SETTINGS_GCONF_PATH "ctb/recentfiles"

typedef enum
{
    IREX_DR1000,
    IREX_DR1000S,
    IREX_DR1000SW
} DeviceType;

// Create a separator widget between 2 setting sections.
GtkWidget* create_separator_widgets();

// Set style of popup window. The window hasn't a title bar, but has borders.
void set_popup_window_style(GtkWindow* window);

// Get device type.
DeviceType get_device_type();

// Set date time.
void set_date_time(time_t t);

// GConfClient initialize and finalize.
void gconf_initialize();
void gconf_finalize();

// Get and set int type value.
int get_value_int(const char* key);
gboolean set_value_int(const char* key, int new_value);

// Get and set bool type value.
gboolean get_value_bool(const char* key);
gboolean set_value_bool(const char* key, gboolean new_value);

// Get and set string type value.
const char* get_value_string(const char* key);
gboolean set_value_string(const char* key, const char* new_value);

// Get string list type value.
GSList* get_value_string_list(const char* key);

#endif // SETTINGS_UTILS_H
