#ifndef __RECENT_H__
#define __RECENT_H__

/**
 * File Name  : recent.h
 *
 * Description: Handling of recently opened documents
 */

/*
 * This file is part of ctb.
 *
 * ctb is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ctb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 Marcel Hendrickx
 * All rights reserved.
 */


//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#include <glib.h>

#include "filemodel.h"

G_BEGIN_DECLS


//----------------------------------------------------------------------------
// Macro Definitions
//---------------------------------------------------------------------------- 


//----------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------


//============================================================================
// Public Functions
//============================================================================

void recent_init(void);

void recent_start (void);

/**---------------------------------------------------------------------------
 *
 * Name :  recent_item
 *
 * @brief  recent: create shortcut in the recent files directory for file or directory
 *
 * @param  [in] directory - directory in which the item is located
 * @param  [in] fileinfo - details of the item
 *
 * @return ER_OK or error code
 *
 *--------------------------------------------------------------------------*/
int recent_item ( const GString           *directory,
                  const filelist_entry_t  *fileinfo  );

G_END_DECLS

#endif // __RECENT_H__
