#ifndef __FILEINFO_H__
#define __FILEINFO_H__

/**
 * File Name  : fileinfo.h
 *
 * Description: Details for a single file as read from filesystem
 */

/*
 * This file is part of ctb.
 *
 * ctb is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ctb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */
 

//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

#include <glib.h>

G_BEGIN_DECLS


//----------------------------------------------------------------------------
// Macro Definitions
//---------------------------------------------------------------------------- 


//----------------------------------------------------------------------------
// Forward Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------

// file details read from filesystem
typedef struct
        {
            GString     *filename;
            gboolean    is_directory;
            gboolean    is_hidden;
            gint64      filesize;
            gint64      filedate;
        } fs_fileinfo_t;


//----------------------------------------------------------------------------
// Global Constants
//----------------------------------------------------------------------------


//============================================================================
// Public Functions
//============================================================================

/**---------------------------------------------------------------------------
 *
 * Name :  fs_fileinfo_new
 *
 * @brief  Create a new fs_fileinfo_t object.
 *
 * @param  --
 *
 * @return The newly allocated object,
 *         with GString elements allocated and set to empty string
 *         and other elements set to binary zero.
 *
 *--------------------------------------------------------------------------*/
fs_fileinfo_t* fs_fileinfo_new (void);


/**---------------------------------------------------------------------------
 *
 * Name :  fs_fileinfo_free
 *
 * @brief  Free the memory allocated to a fs_fileinfo_t object
 *         and free the memory allocated to elements it contains
 *         and clear the pointer passed as argument.
 *
 * @param  [in]  fileinfo - the fs_fileinfo_t object to be freed
 *
 * @return --
 *
 *--------------------------------------------------------------------------*/
#define fs_fileinfo_free(inf)           \
        {                               \
            fs_fileinfo_free_impl(inf); \
            (inf) = NULL;               \
        }
void fs_fileinfo_free_impl (fs_fileinfo_t *inf);


G_END_DECLS

#endif // __FILEINFO_H__
