#ifndef __CTB_LOG_H__
#define __CTB_LOG_H__

/**
 * File Name  : ctb_log.h
 *
 * Description: Macros for debug printing
 *
 * The value of XXX_ON (with XXX one of LOGGING, WARNING or ERROR)
 * determines whether a message will be printed. The value as defined
 * in this file can be overruled by defining them before the inclusion of this file.
 *
 * This file is best included in c files only.
 */

/*
 * This file is part of ctb.
 *
 * ctb is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ctb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2008 iRex Technologies B.V.
 * All rights reserved.
 */


#include <stdio.h>


#define LOG_PREFIX  "CTB"


#ifndef LOGGING_ON
#define LOGGING_ON 0
#endif

#ifndef WARNING_ON
#define WARNING_ON 1
#endif

#ifndef ERROR_ON
#define ERROR_ON 1
#endif


//#if (LOGGING_ON)
//#define LOGPRINTF(format, args...) fprintf(stderr, "(" LOG_PREFIX "_L)" __FILE__ ":%d,%s() " format "\n", __LINE__, __func__ , ##args)
//#else
//#define LOGPRINTF(format, args...) do {} while (0)
//#endif

extern FILE *fplog;

#if (LOGGING_ON)
#define LOGINIT(name) fplog = fopen(name, "w");
#else
#define LOGINIT(name) do {} while (0)
#endif

#if (LOGGING_ON)
#define LOGPRINTF(format, args...) if (fplog) {fprintf(fplog, "(" LOG_PREFIX "_L)" __FILE__ ":%d,%s() " format "\n", __LINE__, __func__ , ##args); fflush(fplog);}
#else
#define LOGPRINTF(format, args...) do {} while (0)
#endif

#if (WARNING_ON)
#define WARNPRINTF(format, args...) if (fplog) {fprintf(fplog, "(" LOG_PREFIX "_W)" __FILE__ ":%d,%s() " format "\n", __LINE__, __func__ , ##args); fflush(fplog);}
#else
#define WARNPRINTF(format, args...) do {} while (0)
#endif

#if (ERROR_ON)
#include <errno.h>
#include <string.h>
#define ERRORPRINTF(format, args...) if (fplog) {fprintf(fplog, "(" LOG_PREFIX "_E)" __FILE__ ":%d,%s() --- " format "\n", __LINE__, __func__ , ##args); fflush(fplog);}
#define ERRNOPRINTF(format, args...) if (fplog) {fprintf(fplog, "(" LOG_PREFIX "_E)" __FILE__ ":%d,%s() --- " format ", errno [%d] [%s]\n", __LINE__, __func__ , ##args, errno, strerror(errno)); fflush(fplog);}
#else
#define ERRORPRINTF(format, args...) do {} while (0)
#define ERRNOPRINTF(format, args...) do {} while (0)
#endif

#endif // __CTB_LOG_H__
