#!/bin/sh
##MPD Update Playlist Script
scriptdir=`/usr/bin/dirname $0`
cd $scriptdir
cd ../../../
export jukebox_path=`pwd`
export LD_LIBRARY_PATH=`echo "$jukebox_path"`/mpd/lib
cd $scriptdir
# bug logging
#echo "$LD_LIBRARY_PATH" > ld_library_path_M.txt
#echo "$jukebox_path" > jukebox_path_M.txt
killall mpd
# start mpd, update database
${jukebox_path}/mpd/bin/mpd ${jukebox_path}/mpd/mpd.conf
mpc clear
mpc update
# remove old files
cd ${jukebox_path}/Music/playlist/ && rm -rf *
cd ${jukebox_path}/mpd/playlists/ && rm -rf *

# PLAYLIST CONTROL
# [1] All-in-One Playlist
mkdir ${jukebox_path}/Music/playlist/01_aio
cd ${jukebox_path}/Music/playlist/01_aio
mpc clear
mpc ls|mpc add
mpc save aio
touch run.sh
echo "#!/bin/sh" > run.sh
echo "mpc clear" >> run.sh
echo "mpc load aio" >> run.sh
echo "mpc play" >> run.sh
chmod a+x run.sh
touch manifest.xml
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Load all Songs as Playlist</Title><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../note.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml

# [3] Artist Search
mkdir ${jukebox_path}/Music/playlist/03_artist
cd ${jukebox_path}/Music/playlist/03_artist
touch manifest.xml # a DIR manifest
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Artist</Title><Description>Search for Artist in Database</Description><Date>2007-04-14T10:27:07</Date></dc-metadata><y-metadata><image>../../note.png</image></y-metadata></metadata><directory><content>.</content></directory></package>" > manifest.xml
# start of clear entry
mkdir ${jukebox_path}/Music/playlist/03_artist/01_clear
cd ${jukebox_path}/Music/playlist/03_artist/01_clear
touch run.sh
echo "#!/bin/sh" > run.sh 
echo "mpc clear" >> run.sh
chmod a+x run.sh
touch manifest.xml
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Clear All Songs in Playlist</Title><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../.delete.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
# end of clear entry
cd ${jukebox_path}/Music/playlist/03_artist
cat ${jukebox_path}/mpd/mpd.db.txt |grep Artist:|sed 's/Artist: //'|sort -u > .s_artist.txt
int=100
file_artist=.s_artist.txt
while read i  
do	
	mpc clear
	# "" is needed, when artist's name is more than 1 word long
	mpc search artist "$i"|mpc add
	mpc save $int.artist
	mkdir ${jukebox_path}/Music/playlist/03_artist/$int.artist
	cd ${jukebox_path}/Music/playlist/03_artist/$int.artist
	touch manifest.xml
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>$i</Title><Description>Add Artist $i to Playlist</Description><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../.add.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
	touch run.sh
	echo "#!/bin/sh" > run.sh
	echo "mpc load $int.artist" >> run.sh
	echo "mpc play" >> run.sh
	chmod a+x run.sh
	int=`expr $int + 1`
done < "$file_artist"

# [4] Album Search
mkdir ${jukebox_path}/Music/playlist/04_album
cd ${jukebox_path}/Music/playlist/04_album
touch manifest.xml # a DIR manifest
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Album</Title><Description>Search for Album in Database</Description><Date>2007-04-14T10:27:07</Date></dc-metadata><y-metadata><image>../../note.png</image></y-metadata></metadata><directory><content>.</content></directory></package>" > manifest.xml
# start of clear entry
mkdir ${jukebox_path}/Music/playlist/04_album/01_clear
cd ${jukebox_path}/Music/playlist/04_album/01_clear
touch run.sh
echo "#!/bin/sh" > run.sh 
echo "mpc clear" >> run.sh
chmod a+x run.sh
touch manifest.xml
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Clear All Songs in Playlist</Title><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../.delete.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
# end of clear entry
cd ${jukebox_path}/Music/playlist/04_album
cat ${jukebox_path}/mpd/mpd.db.txt |grep Album:|sed 's/Album: //'|sort -u > .s_album.txt
int=100
file_album=.s_album.txt
while read i  
do	
	mpc clear
	mpc search album "$i"|mpc add
	mpc save $int.album
	mkdir ${jukebox_path}/Music/playlist/04_album/$int.album
	cd ${jukebox_path}/Music/playlist/04_album/$int.album
	touch manifest.xml
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>$i</Title><Description>Add Album $i to Playlist</Description><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../.add.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
	touch run.sh
	echo "#!/bin/sh" > run.sh
	echo "mpc load $int.album" >> run.sh
	echo "mpc play" >> run.sh
	chmod a+x run.sh
	int=`expr $int + 1`
done < "$file_album"

# [5] Genre Search
mkdir ${jukebox_path}/Music/playlist/05_genre
cd ${jukebox_path}/Music/playlist/05_genre
touch manifest.xml # a DIR manifest
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Genre</Title><Description>Search for Genre in Database</Description><Date>2007-04-14T10:27:07</Date></dc-metadata><y-metadata><image>../../note.png</image></y-metadata></metadata><directory><content>.</content></directory></package>" > manifest.xml
# start of clear entry
mkdir ${jukebox_path}/Music/playlist/05_genre/01_clear
cd ${jukebox_path}/Music/playlist/05_genre/01_clear
touch run.sh
echo "#!/bin/sh" > run.sh 
echo "mpc clear" >> run.sh
chmod a+x run.sh
touch manifest.xml
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Clear All Songs in Playlist</Title><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../.delete.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
# end of clear entry
cd ${jukebox_path}/Music/playlist/05_genre
cat ${jukebox_path}/mpd/mpd.db.txt |grep Genre:|sed 's/Genre: //'|sort -u > .s_genre.txt
int=100
file_genre=.s_genre.txt
while read i  
do	
	mpc clear
	mpc search genre "$i"|mpc add
	mpc save $int.genre
	mkdir ${jukebox_path}/Music/playlist/05_genre/$int.genre
	cd ${jukebox_path}/Music/playlist/05_genre/$int.genre
	touch manifest.xml
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>$i</Title><Description>Add Genre $i to Playlist</Description><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../.add.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
	touch run.sh
	echo "#!/bin/sh" > run.sh
	echo "mpc load $int.genre" >> run.sh
	echo "mpc play" >> run.sh
	chmod a+x run.sh
	int=`expr $int + 1`
done < "$file_genre"

# [6] Date Search
mkdir ${jukebox_path}/Music/playlist/06_date
cd ${jukebox_path}/Music/playlist/06_date
touch manifest.xml # a DIR manifest
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Date</Title><Description>Search for Date in Database</Description><Date>2007-04-14T10:27:07</Date></dc-metadata><y-metadata><image>../../note.png</image></y-metadata></metadata><directory><content>.</content></directory></package>" > manifest.xml
# start of clear entry
mkdir ${jukebox_path}/Music/playlist/06_date/01_clear
cd ${jukebox_path}/Music/playlist/06_date/01_clear
touch run.sh
echo "#!/bin/sh" > run.sh 
echo "mpc clear" >> run.sh
chmod a+x run.sh
touch manifest.xml
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Clear All Songs in Playlist</Title><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../.delete.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
# end of clear entry
cd ${jukebox_path}/Music/playlist/06_date
cat ${jukebox_path}/mpd/mpd.db.txt |grep Date:|sed 's/Date: //'|sort -nu > .s_date.txt
int=100
file_date=.s_date.txt
while read i  
do	
	mpc clear
	mpc search date "$i"|mpc add
	mpc save $int.date
	mkdir ${jukebox_path}/Music/playlist/06_date/$int.date
	cd ${jukebox_path}/Music/playlist/06_date/$int.date
	touch manifest.xml
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>$i</Title><Description>Add Date $i to Playlist</Description><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../.add.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
	touch run.sh
	echo "#!/bin/sh" > run.sh
	echo "mpc load $int.date" >> run.sh
	echo "mpc play" >> run.sh
	chmod a+x run.sh
	int=`expr $int + 1`
done < "$file_date"

# [2] external m3u-files
mkdir ${jukebox_path}/Music/playlist/02_external_m3u
cd ${jukebox_path}/Music/playlist/02_external_m3u
touch manifest.xml # a DIR manifest
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Load external .m3u Files</Title><Description>You can load here the playlists from the mp3 dir &#10;</Description><Date>2007-04-14T10:27:07</Date></dc-metadata><y-metadata><image>../../note.png</image></y-metadata></metadata><directory><content>.</content></directory></package>" > manifest.xml
# start of update external playlists
mkdir ${jukebox_path}/Music/playlist/02_external_m3u/01_update
cd ${jukebox_path}/Music/playlist/02_external_m3u/01_update
touch manifest.xml
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>Update external .m3u Files</Title><Description>Use this one after you have edited, added or removed .m3u files.</Description><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../note.png</image><startpage>../../../update_e.m3u.sh</startpage></y-metadata></metadata></package>" > manifest.xml
# end of update external playlists
cd ${jukebox_path}/Music/playlist/02_external_m3u
ls ${jukebox_path}/mp3|grep .m3u|sed 's/.m3u//'  >.e_m3u.txt
int=100
file_m3u=.e_m3u.txt
while read i  
do	
	mkdir ${jukebox_path}/Music/playlist/02_external_m3u/$int.e.m3u
	cd ${jukebox_path}/Music/playlist/02_external_m3u/$int.e.m3u
	cp ${jukebox_path}/mp3/"$i".m3u ${jukebox_path}/mpd/playlists/$int.e.m3u
	touch manifest.xml
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?><package><metadata><dc-metadata><Title>$i</Title><Description>Load $i as Playlist</Description><Date>2007-04-15T10:08:46</Date></dc-metadata><y-metadata><image>../../../note.png</image><startpage>run.sh</startpage></y-metadata></metadata></package>" > manifest.xml
	touch run.sh
	echo "#!/bin/sh" > run.sh
	echo "mpc clear" >> run.sh
	echo "mpc load $int.e" >> run.sh
	echo "mpc play" >> run.sh
	chmod a+x run.sh
	int=`expr $int + 1`
done < "$file_m3u"

# Playback
mpc clear
mpc load aio
mpc play
mpc volume 65
mpc repeat on
# Status Message
cd $scriptdir
cd ..
target=`pwd`
${target}/02_Status/run.sh